/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.migration.core.ServerMigrationFailureException;

public class ServerMigrationTaskResult {
    private static final Map<String, String> NO_ATTRIBUTES = Collections.unmodifiableMap(new HashMap());
    public static final ServerMigrationTaskResult SUCCESS = new ServerMigrationTaskResult(Status.SUCCESS, null, null);
    public static final ServerMigrationTaskResult SKIPPED = new ServerMigrationTaskResult(Status.SKIPPED, null, null);
    private final Status status;
    private final ServerMigrationFailureException failReason;
    private final Map<String, String> attributes;

    public static ServerMigrationTaskResult fail(ServerMigrationFailureException failReason) {
        return new ServerMigrationTaskResult(Status.FAIL, failReason, null);
    }

    private ServerMigrationTaskResult(Status status, ServerMigrationFailureException failReason, Map<String, String> attributes) {
        this.status = status;
        if (status == null) {
            throw new IllegalArgumentException("null status");
        }
        this.failReason = failReason;
        this.attributes = attributes != null ? Collections.unmodifiableMap(attributes) : NO_ATTRIBUTES;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Status getStatus() {
        return this.status;
    }

    public ServerMigrationFailureException getFailReason() {
        return this.failReason;
    }

    public String toString() {
        return this.status.toString();
    }

    public static class Builder {
        private Status status;
        private ServerMigrationFailureException failReason;
        private Map<String, String> attributes;

        public Builder success() {
            this.status = Status.SUCCESS;
            this.failReason = null;
            return this;
        }

        public Builder skipped() {
            this.status = Status.SKIPPED;
            this.failReason = null;
            return this;
        }

        public Builder fail(ServerMigrationFailureException failReason) {
            this.status = Status.FAIL;
            this.failReason = failReason;
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value.toString());
            return this;
        }

        public ServerMigrationTaskResult build() {
            return new ServerMigrationTaskResult(this.status, this.failReason, this.attributes);
        }
    }

    public static enum Status {
        FAIL,
        SUCCESS,
        SKIPPED;

    }
}

