/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import java.util.Objects;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.AfterTaskRun;
import org.jboss.migration.core.task.component.BeforeTaskRun;
import org.jboss.migration.core.task.component.BuildParameters;
import org.jboss.migration.core.task.component.ComponentTaskBuilder;
import org.jboss.migration.core.task.component.TaskNameBuilder;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public abstract class ComponentTask
implements ServerMigrationTask {
    private final ServerMigrationTaskName name;
    private final TaskRunnable taskRunnable;

    protected ComponentTask(ServerMigrationTaskName name, TaskRunnable taskRunnable) {
        this.name = Objects.requireNonNull(name);
        this.taskRunnable = Objects.requireNonNull(taskRunnable);
    }

    @Override
    public ServerMigrationTaskName getName() {
        return this.name;
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        return this.taskRunnable.run(context);
    }

    public static abstract class Builder<P extends BuildParameters, T extends Builder<P, T>>
    implements ComponentTaskBuilder<P, T> {
        private TaskNameBuilder<? super P> taskNameBuilder;
        private TaskSkipPolicy.Builder<? super P> skipPolicyBuilder;
        private BeforeTaskRun.Builder<? super P> beforeRunBuilder;
        private AfterTaskRun.Builder<? super P> afterRunBuilder;

        protected Builder() {
        }

        @Override
        public T nameBuilder(TaskNameBuilder<? super P> builder) {
            this.taskNameBuilder = builder;
            return this.getThis();
        }

        protected TaskNameBuilder<? super P> getTaskNameBuilder() {
            return this.taskNameBuilder;
        }

        @Override
        public T skipPolicyBuilder(TaskSkipPolicy.Builder<? super P> builder) {
            this.skipPolicyBuilder = builder;
            return this.getThis();
        }

        protected TaskSkipPolicy.Builder<? super P> getSkipPolicyBuilder() {
            return this.skipPolicyBuilder;
        }

        @Override
        public T beforeRunBuilder(BeforeTaskRun.Builder<? super P> builder) {
            this.beforeRunBuilder = builder;
            return this.getThis();
        }

        protected BeforeTaskRun.Builder<? super P> getBeforeRunBuilder() {
            return this.beforeRunBuilder;
        }

        @Override
        public T afterRunBuilder(AfterTaskRun.Builder<? super P> builder) {
            this.afterRunBuilder = builder;
            return this.getThis();
        }

        protected AfterTaskRun.Builder<? super P> getAfterRunBuilder() {
            return this.afterRunBuilder;
        }

        protected ServerMigrationTaskName buildName(P parameters) {
            return Objects.requireNonNull(this.taskNameBuilder).build(parameters);
        }

        protected TaskRunnable buildRunnable(P parameters) {
            TaskRunnable.Builder<P> runnableBuilder = Objects.requireNonNull(this.getRunnableBuilder());
            TaskRunnable runnable = runnableBuilder.build(parameters);
            TaskSkipPolicy.Builder<P> skipPolicyBuilder = this.getSkipPolicyBuilder();
            TaskSkipPolicy skipPolicy = skipPolicyBuilder != null ? skipPolicyBuilder.build(parameters) : null;
            BeforeTaskRun.Builder<P> beforeRunBuilder = this.getBeforeRunBuilder();
            BeforeTaskRun beforeRun = beforeRunBuilder != null ? beforeRunBuilder.build(parameters) : null;
            AfterTaskRun.Builder<P> afterRunBuilder = this.getAfterRunBuilder();
            AfterTaskRun afterRun = afterRunBuilder != null ? afterRunBuilder.build(parameters) : null;
            return context -> {
                if (skipPolicy != null && skipPolicy.isSkipped(context)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (beforeRun != null) {
                    beforeRun.beforeRun(context);
                }
                ServerMigrationTaskResult result = runnable.run(context);
                if (afterRun != null) {
                    afterRun.afterRun(context);
                }
                return result;
            };
        }

        @Override
        public ServerMigrationTask build(P params) {
            return this.buildTask(this.buildName(params), this.buildRunnable(params));
        }

        protected abstract T getThis();

        protected abstract TaskRunnable.Builder<? super P> getRunnableBuilder();

        protected abstract ServerMigrationTask buildTask(ServerMigrationTaskName var1, TaskRunnable var2);
    }
}

