/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly13.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly11.task.subsystem.elytron.Permission;

public class PermissionSetAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String permissionSet;
    private List<Permission> permissions;

    public PermissionSetAddOperation(PathAddress subsystemPathAddress, String permissionSet) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.permissionSet = permissionSet;
        this.permissions = new ArrayList<Permission>();
    }

    public PermissionSetAddOperation addPermission(Permission permission) {
        this.permissions.add(permission);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("permission-set", this.permissionSet);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.permissions != null && !this.permissions.isEmpty()) {
            ModelNode permissionsNode = operation.get("permissions").setEmptyList();
            for (Permission permission : this.permissions) {
                permissionsNode.add(permission.toModelNode());
            }
        }
        return operation;
    }
}

