/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import java.util.Arrays;
import java.util.Locale;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserChoice;
import org.jboss.migration.core.console.UserInput;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class UserChoiceWithOtherOption
extends UserChoice {
    private static final String OTHER = ServerMigrationLogger.ROOT_LOGGER.other().toLowerCase(Locale.getDefault());

    private static String[] addOtherToOptions(String[] options, String otherOption) {
        String[] optionsCopy = Arrays.copyOf(options, options.length + 1);
        optionsCopy[optionsCopy.length - 1] = otherOption;
        return optionsCopy;
    }

    public UserChoiceWithOtherOption(ConsoleWrapper theConsole, String[] messageLines, String[] options, String otherOption, String prompt, ResultHandler resultHandler) {
        super(theConsole, messageLines, UserChoiceWithOtherOption.addOtherToOptions(options, otherOption), prompt, (UserChoice.ResultHandler)new ResultHandlerWrapper(theConsole, resultHandler, otherOption));
    }

    public UserChoiceWithOtherOption(ConsoleWrapper theConsole, String messageLine, String[] options, String otherOption, String prompt, ResultHandler resultHandler) {
        this(theConsole, new String[]{messageLine}, options, otherOption, prompt, resultHandler);
    }

    public UserChoiceWithOtherOption(ConsoleWrapper theConsole, String[] options, String otherOption, String prompt, ResultHandler resultHandler) {
        this(theConsole, (String[])null, options, otherOption, prompt, resultHandler);
    }

    public static interface ResultHandler
    extends UserChoice.ResultHandler {
        public void onOther(String var1);
    }

    private static class ResultHandlerWrapper
    implements UserChoice.ResultHandler {
        private final ConsoleWrapper theConsole;
        private final ResultHandler resultHandler;
        private final String otherChoice;

        private ResultHandlerWrapper(ConsoleWrapper theConsole, ResultHandler resultHandler, String otherChoice) {
            this.theConsole = theConsole;
            this.resultHandler = resultHandler;
            this.otherChoice = otherChoice;
        }

        @Override
        public void onChoice(String choice) {
            if (!this.otherChoice.equals(choice)) {
                this.resultHandler.onChoice(choice);
            } else {
                UserInput.ResultHandler inputResultHandler = new UserInput.ResultHandler(){

                    @Override
                    public void onInput(String input) {
                        resultHandler.onOther(input);
                    }

                    @Override
                    public void onError() {
                        resultHandler.onError();
                    }
                };
                new UserInput(this.theConsole, null, ServerMigrationLogger.ROOT_LOGGER.otherChoice(), inputResultHandler).execute();
            }
        }

        @Override
        public void onError() {
            this.resultHandler.onError();
        }
    }
}

