/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import org.jboss.dmr.ModelNode;

public class ResolvablePath {
    private final String path;
    private final String relativeTo;

    public ResolvablePath(String path, String relativeTo) {
        if (path == null && relativeTo == null) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.relativeTo = relativeTo;
    }

    public ResolvablePath(ModelNode modelNode) {
        this(modelNode.hasDefined("path") ? modelNode.get("path").asString() : null, modelNode.hasDefined("relative-to") ? modelNode.get("relative-to").asString() : null);
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public static ResolvablePath fromPathExpression(String path) {
        if ((path = path.trim()).indexOf("${") == 0) {
            int relativeToEnd = path.indexOf(125);
            if (relativeToEnd < 2) {
                throw new IllegalArgumentException("invalid expression path '" + path + "'");
            }
            int nextStart = path.indexOf("${", 2);
            if (nextStart > 0 && nextStart < relativeToEnd) {
                throw new IllegalArgumentException("nested expression path '" + path + "'");
            }
            String relativeTo = path.substring(2, relativeToEnd);
            if (path.length() > relativeToEnd + 1) {
                String relativePath = path.substring(relativeToEnd + 1);
                if (relativePath.charAt(0) == '/' || relativePath.charAt(0) == '\\') {
                    relativePath = relativePath.substring(1);
                }
                return new ResolvablePath(relativePath, relativeTo);
            }
            return new ResolvablePath(null, relativeTo);
        }
        return new ResolvablePath(path, null);
    }

    public String toString() {
        return "path='" + String.valueOf(this.path) + "', relativeTo='" + String.valueOf(this.relativeTo);
    }
}

