/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.SecurityRealmResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;
import org.jboss.migration.wfly10.config.task.update.MigrateResolvablePath;

public class MigrateCompatibleSecurityRealms<S extends JBossServer<S>>
extends ManageableServerConfigurationCompositeTask.Builder<JBossServerConfigurationPath<S>> {
    public MigrateCompatibleSecurityRealms() {
        this.name("security-realms.migrate-properties");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().infof("Migrating security realms...", new Object[0]));
        this.subtasks(SecurityRealmResource.class, ManageableResourceCompositeSubtasks.of(new Subtask()));
        this.afterRun(context -> context.getLogger().debugf("Security realms migration done.", new Object[0]));
    }

    protected static class Subtask<S extends JBossServer<S>>
    extends ManageableResourceLeafTask.Builder<JBossServerConfigurationPath<S>, SecurityRealmResource> {
        protected Subtask() {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("security-realm." + ((SecurityRealmResource)parameters.getResource()).getResourceName() + ".migrate-properties").build());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                SecurityRealmResource securityRealmResource = (SecurityRealmResource)params.getResource();
                String securityRealmConfigName = securityRealmResource.getResourceAbsoluteName();
                context.getLogger().debugf("Security realm %s migration starting...", (Object)securityRealmConfigName);
                ModelNode securityRealmConfig = securityRealmResource.getResourceConfiguration();
                if (securityRealmConfig.hasDefined(new String[]{"authentication", "properties"})) {
                    this.copyPropertiesFile("authentication", securityRealmConfig, (JBossServerConfigurationPath)params.getSource(), securityRealmResource, context);
                }
                if (securityRealmConfig.hasDefined(new String[]{"authorization", "properties"})) {
                    this.copyPropertiesFile("authorization", securityRealmConfig, (JBossServerConfigurationPath)params.getSource(), securityRealmResource, context);
                }
                context.getLogger().infof("Security realm %s migrated.", (Object)securityRealmConfigName);
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }

        private void copyPropertiesFile(String propertiesName, ModelNode securityRealmConfig, JBossServerConfigurationPath<S> source, SecurityRealmResource securityRealmResource, TaskContext context) throws ServerMigrationFailureException {
            ModelNode properties = securityRealmConfig.get(new String[]{propertiesName, "properties"});
            if (properties.hasDefined("path")) {
                new MigrateResolvablePath(new ResolvablePath(properties), source, securityRealmResource.getServerConfiguration()).run(context);
            }
        }
    }
}

