/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.management.DeploymentResource;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.DeploymentOverlayResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.DeploymentResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.ManagementInterfaceResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SecurityRealmResourceImpl;
import org.jboss.migration.wfly10.config.management.impl.SubsystemResourceImpl;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.StandaloneServer;

public class EmbeddedStandaloneServerConfiguration
extends AbstractManageableServerConfiguration
implements StandaloneServerConfiguration {
    private final String config;
    private StandaloneServer standaloneServer;
    private final DeploymentResourceImpl.Factory deploymentResources;
    private final DeploymentOverlayResourceImpl.Factory deploymentOverlayResources;
    private final ManagementInterfaceResourceImpl.Factory managementInterfaceResources;
    private final SecurityRealmResourceImpl.Factory securityRealmResources;
    private final SubsystemResourceImpl.Factory subsystemResources;

    public EmbeddedStandaloneServerConfiguration(JBossServerConfiguration configurationPath, WildFlyServer10 server) {
        super("", PathAddress.EMPTY_ADDRESS, configurationPath, server);
        this.config = configurationPath.getPath().getFileName().toString();
        this.deploymentResources = new DeploymentResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.deploymentResources);
        this.deploymentOverlayResources = new DeploymentOverlayResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.deploymentOverlayResources);
        this.subsystemResources = new SubsystemResourceImpl.Factory(this.getResourcePathAddress(), this);
        this.addChildResourceFactory(this.subsystemResources);
        PathAddress managementCoreServicePathAddress = this.getResourcePathAddress().append("core-service", "management");
        this.managementInterfaceResources = new ManagementInterfaceResourceImpl.Factory(managementCoreServicePathAddress, this);
        this.addChildResourceFactory(this.managementInterfaceResources);
        this.securityRealmResources = new SecurityRealmResourceImpl.Factory(managementCoreServicePathAddress, this);
        this.addChildResourceFactory(this.securityRealmResources);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        String[] cmds = new String[]{"--server-config=" + this.config, "--admin-only"};
        String[] systemPackages = new String[]{"org.jboss.logmanager"};
        this.standaloneServer = EmbeddedProcessFactory.createStandaloneServer((String)this.getServer().getBaseDir().toString(), null, (String[])systemPackages, (String[])cmds);
        try {
            this.standaloneServer.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new ManagementOperationException(e);
        }
        return this.standaloneServer.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
        this.writeConfiguration();
        this.standaloneServer.stop();
        this.standaloneServer = null;
    }

    @Override
    public DeploymentResource getDeploymentResource(String resourceName) throws ManagementOperationException {
        return (DeploymentResource)this.deploymentResources.getResource(resourceName);
    }

    @Override
    public List<DeploymentResource> getDeploymentResources() throws ManagementOperationException {
        return this.deploymentResources.getResources();
    }

    @Override
    public Set<String> getDeploymentResourceNames() throws ManagementOperationException {
        return this.deploymentResources.getResourceNames();
    }

    @Override
    public PathAddress getDeploymentResourcePathAddress(String resourceName) {
        return this.deploymentResources.getResourcePathAddress(resourceName);
    }

    @Override
    public void removeDeploymentResource(String resourceName) throws ManagementOperationException {
        this.deploymentResources.removeResource(resourceName);
    }

    public static class ConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public StandaloneServerConfiguration getManageableConfiguration(JBossServerConfiguration configurationPath, WildFlyServer10 server) {
            return new EmbeddedStandaloneServerConfiguration(configurationPath, server);
        }
    }
}

