/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.management.ManageableResource;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationComponentTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceComponentTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.resources.ManageableResourcesComponentTaskBuilder;

public class ServerConfigurationMigration<S, T extends ManageableServerConfiguration> {
    public static final String MIGRATION_REPORT_TASK_ATTR_SOURCE = "source";
    private final String configType;
    protected final XMLConfigurationProvider xmlConfigurationProvider;
    protected final ManageableConfigurationProvider<T> manageableConfigurationProvider;
    protected final List<ManageableServerConfigurationTaskFactory<S, T>> manageableConfigurationSubtaskFactories;
    protected final List<XMLConfigurationSubtaskFactory<S>> xmlConfigurationSubtaskFactories;

    protected ServerConfigurationMigration(BaseBuilder<S, T, ?> builder) {
        this.configType = ((BaseBuilder)builder).configType;
        this.xmlConfigurationProvider = ((BaseBuilder)builder).xmlConfigurationProvider;
        this.manageableConfigurationProvider = ((BaseBuilder)builder).manageableConfigurationProvider;
        this.manageableConfigurationSubtaskFactories = Collections.unmodifiableList(((BaseBuilder)builder).manageableConfigurationSubtaskFactories.factories);
        this.xmlConfigurationSubtaskFactories = Collections.unmodifiableList(((BaseBuilder)builder).xmlConfigurationSubtaskFactories);
    }

    public String getConfigType() {
        return this.configType;
    }

    protected ServerMigrationTask getServerMigrationTask(final S source, final JBossServerConfiguration.Type targetConfigurationType, final WildFlyServer10 target) {
        final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(this.getConfigType() + "-configuration").addAttribute(MIGRATION_REPORT_TASK_ATTR_SOURCE, source.toString()).build();
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return taskName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerMigrationTaskResult run(TaskContext context) {
                ConsoleWrapper consoleWrapper = context.getConsoleWrapper();
                consoleWrapper.printf("%n", new Object[0]);
                context.getLogger().infof("Migrating %s configuration %s", (Object)ServerConfigurationMigration.this.getConfigType(), source);
                JBossServerConfiguration targetConfiguration = ServerConfigurationMigration.this.xmlConfigurationProvider.getXMLConfiguration(source, targetConfigurationType, target, context);
                for (XMLConfigurationSubtaskFactory<Object> xMLConfigurationSubtaskFactory : ServerConfigurationMigration.this.xmlConfigurationSubtaskFactories) {
                    ServerMigrationTask subtask = xMLConfigurationSubtaskFactory.getTask(source, targetConfiguration);
                    if (subtask == null) continue;
                    context.execute(subtask);
                }
                if (ServerConfigurationMigration.this.manageableConfigurationProvider != null) {
                    Object configurationManagement = ServerConfigurationMigration.this.manageableConfigurationProvider.getManageableConfiguration(targetConfiguration, target);
                    context.getLogger().debugf("Starting target configuration %s", (Object)targetConfiguration.getPath().getFileName());
                    configurationManagement.start();
                    try {
                        ModelNode modelNode = Util.createEmptyOperation((String)"read-resource", null);
                        modelNode.get("recursive").set(true);
                        modelNode.get("include-defaults").set(false);
                        for (ManageableServerConfigurationTaskFactory manageableServerConfigurationTaskFactory : ServerConfigurationMigration.this.manageableConfigurationSubtaskFactories) {
                            ServerMigrationTask subtask = manageableServerConfigurationTaskFactory.getTask(source, configurationManagement);
                            if (subtask == null) continue;
                            context.execute(subtask);
                        }
                    }
                    finally {
                        configurationManagement.stop();
                    }
                }
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    public static class ManageableServerConfigurationTaskFactories<S, T extends ManageableServerConfiguration> {
        private final List<ManageableServerConfigurationTaskFactory<S, T>> factories = new ArrayList<ManageableServerConfigurationTaskFactory<S, T>>();

        public List<ManageableServerConfigurationTaskFactory<S, T>> getFactories() {
            return Collections.unmodifiableList(this.factories);
        }

        public void add(ManageableServerConfigurationTaskFactory<S, T> subtaskFactory) {
            this.factories.add(subtaskFactory);
        }

        public void addAll(Collection<ManageableServerConfigurationTaskFactory<S, T>> subtaskFactories) {
            this.factories.addAll(subtaskFactories);
        }
    }

    public static class Builder<S, T extends ManageableServerConfiguration>
    extends BaseBuilder<S, T, Builder<S, T>> {
        public Builder(String configType, XMLConfigurationProvider xmlConfigurationProvider) {
            super(configType, xmlConfigurationProvider);
        }

        @Override
        protected Builder<S, T> getThis() {
            return this;
        }
    }

    public static abstract class BaseBuilder<S, T extends ManageableServerConfiguration, B extends BaseBuilder<S, T, B>> {
        private final String configType;
        private final XMLConfigurationProvider<S> xmlConfigurationProvider;
        private ManageableConfigurationProvider<T> manageableConfigurationProvider;
        private final ManageableServerConfigurationTaskFactories<S, T> manageableConfigurationSubtaskFactories;
        private final List<XMLConfigurationSubtaskFactory<S>> xmlConfigurationSubtaskFactories;

        public BaseBuilder(String configType, XMLConfigurationProvider<S> xmlConfigurationProvider) {
            this.configType = configType;
            this.xmlConfigurationProvider = xmlConfigurationProvider;
            this.manageableConfigurationSubtaskFactories = new ManageableServerConfigurationTaskFactories();
            this.xmlConfigurationSubtaskFactories = new ArrayList<XMLConfigurationSubtaskFactory<S>>();
        }

        public B manageableConfigurationProvider(ManageableConfigurationProvider<T> manageableConfigurationProvider) {
            this.manageableConfigurationProvider = manageableConfigurationProvider;
            return this.getThis();
        }

        public B subtask(ManageableServerConfigurationTaskFactory<S, T> subtaskFactory) {
            this.manageableConfigurationSubtaskFactories.add(subtaskFactory);
            return this.getThis();
        }

        public B subtask(ManageableResourceComponentTaskBuilder<S, ManageableResource, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public B subtask(ManageableResourcesComponentTaskBuilder<S, ManageableResource, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public B subtask(ManageableServerConfigurationComponentTaskBuilder<S, ?> subtaskBuilder) {
            return this.subtask(ManageableServerConfigurationTaskFactory.of(subtaskBuilder));
        }

        public B subtask(XMLConfigurationSubtaskFactory<S> subtaskFactory) {
            this.xmlConfigurationSubtaskFactories.add(subtaskFactory);
            return this.getThis();
        }

        protected abstract B getThis();

        public ServerConfigurationMigration<S, T> build() {
            return new ServerConfigurationMigration(this);
        }
    }

    public static interface XMLConfigurationSubtaskFactory<S> {
        public ServerMigrationTask getTask(S var1, JBossServerConfiguration var2);
    }

    public static interface ManageableConfigurationProvider<T extends ManageableServerConfiguration> {
        public T getManageableConfiguration(JBossServerConfiguration var1, WildFlyServer10 var2);
    }

    public static interface XMLConfigurationProvider<S> {
        public JBossServerConfiguration getXMLConfiguration(S var1, JBossServerConfiguration.Type var2, WildFlyServer10 var3, TaskContext var4);
    }
}

