/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.management.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class AddSubsystemResourceSubtaskBuilder<S>
extends ManageableResourceLeafTask.Builder<S, SubsystemResource.Parent> {
    private String subsystem;

    public AddSubsystemResourceSubtaskBuilder(String subsystem) {
        this.subsystem = subsystem;
        this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("subsystem." + subsystem + ".add-config").addAttribute("name", ((SubsystemResource.Parent)parameters.getResource()).getResourceAbsoluteName()).build());
        this.runBuilder(params -> taskContext -> {
            SubsystemResource.Parent parent = (SubsystemResource.Parent)params.getResource();
            if (parent.hasSubsystemResource(subsystem)) {
                taskContext.getLogger().debugf("Skipped adding subsystem config %s, already exists.", (Object)parent.getSubsystemResourceAbsoluteName(subsystem));
                return ServerMigrationTaskResult.SKIPPED;
            }
            String configName = parent.getSubsystemResourceAbsoluteName(subsystem);
            taskContext.getLogger().debugf("Adding subsystem config %s...", (Object)configName);
            this.addConfiguration((ManageableResourceBuildParameters<S, SubsystemResource.Parent>)params, taskContext);
            taskContext.getLogger().infof("Subsystem config %s added.", (Object)configName);
            return ServerMigrationTaskResult.SUCCESS;
        });
    }

    protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
        ModelNode op = Util.createAddOperation((PathAddress)params.getResource().getSubsystemResourcePathAddress(this.subsystem));
        params.getServerConfiguration().executeManagementOperation(op);
    }

    public String getSubsystem() {
        return this.subsystem;
    }
}

