/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.EnvironmentProperties;
import org.jboss.migration.core.env.EnvironmentProperty;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.jboss.CopyPath;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;

public class MigrateScannerDeployments<S extends JBossServer<S>>
extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfiguration<S>> {
    private static final EnvironmentProperty<List<String>> ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS = EnvironmentProperties.newStringListProperty((String)"processedDeploymentScannerDirs", new ArrayList());
    private static final String SCANNER = "scanner";

    public MigrateScannerDeployments() {
        this.name("deployments.migrate-deployment-scanner-deployments");
        this.runBuilder(params -> context -> {
            JBossServerConfiguration sourceConfiguration = (JBossServerConfiguration)params.getSource();
            ManageableServerConfiguration targetConfiguration = params.getServerConfiguration();
            for (SubsystemResource subsystemResource : targetConfiguration.findResources(SubsystemResource.class, "deployment-scanner")) {
                context.getLogger().debugf("Deployment-scanner found, analysing its configuration %s...", (Object)subsystemResource.getResourceAbsoluteName());
                ModelNode subsystemConfig = subsystemResource.getResourceConfiguration();
                if (subsystemConfig == null || !subsystemConfig.hasDefined(SCANNER)) continue;
                for (Property property : subsystemConfig.get(SCANNER).asPropertyList()) {
                    List deployments;
                    ModelNode scannerConfig = property.getValue();
                    if (!scannerConfig.hasDefined("path")) continue;
                    ResolvablePath scannerConfigPath = new ResolvablePath(scannerConfig);
                    Path sourceDeploymentsDir = sourceConfiguration.resolvePath(scannerConfigPath);
                    Path targetDeploymentsDir = targetConfiguration.resolvePath(scannerConfigPath);
                    if (sourceDeploymentsDir == null) {
                        if (targetDeploymentsDir == null) {
                            throw new ServerMigrationFailureException("Failed to resolve deployment scanner path " + scannerConfig);
                        }
                        sourceDeploymentsDir = targetDeploymentsDir.startsWith(targetConfiguration.getServer().getBaseDir()) ? sourceConfiguration.getServer().getBaseDir().resolve(targetConfiguration.getServer().getBaseDir().relativize(targetDeploymentsDir)) : targetDeploymentsDir;
                    } else if (targetDeploymentsDir == null) {
                        targetDeploymentsDir = sourceDeploymentsDir.startsWith(sourceConfiguration.getServer().getBaseDir()) ? targetConfiguration.getServer().getBaseDir().resolve(sourceConfiguration.getServer().getBaseDir().relativize(sourceDeploymentsDir)) : sourceDeploymentsDir;
                    }
                    TaskEnvironment taskEnvironment = new TaskEnvironment(context);
                    List processedDeploymentScannerDirs = (List)ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS.getValue((Environment)taskEnvironment);
                    String sourceDeploymentsDirAsString = sourceDeploymentsDir.toString();
                    if (processedDeploymentScannerDirs.contains(sourceDeploymentsDirAsString)) {
                        context.getLogger().debugf("Already processed source's deployments directory '%s', skipping it...", (Object)sourceDeploymentsDir);
                        continue;
                    }
                    processedDeploymentScannerDirs.add(sourceDeploymentsDirAsString);
                    ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS.setValue((Object)processedDeploymentScannerDirs, (Environment)taskEnvironment);
                    context.getLogger().infof("Found deployment scanner '%s' watching directory '%s', searching for deployments in it...", (Object)property.getName(), (Object)sourceDeploymentsDir);
                    try {
                        deployments = Files.list(sourceDeploymentsDir).filter(path -> Files.exists(path.resolveSibling(path.getFileName().toString() + ".deployed"), new LinkOption[0])).map(path -> path.getFileName()).collect(Collectors.toList());
                    }
                    catch (IOException e) {
                        throw new ServerMigrationFailureException("Failed to read the scanner's deployments directory", (Throwable)e);
                    }
                    if (deployments.isEmpty()) {
                        context.getLogger().debugf("No scanner's deployments found in '%s'.", (Object)sourceDeploymentsDir);
                        continue;
                    }
                    context.getLogger().infof("Scanner's deployments found: %s", deployments);
                    MigrationEnvironment environment = context.getMigrationEnvironment();
                    boolean migrateDeployments = !new TaskEnvironment((Environment)environment, context.getTaskName()).isSkippedByEnvironment() && !new TaskEnvironment((Environment)environment, context.getParentTask().getTaskName()).isSkippedByEnvironment();
                    boolean confirmEachDeployment = false;
                    if (context.isInteractive()) {
                        BasicResultHandlers.UserConfirmation migrateUserConfirmation = new BasicResultHandlers.UserConfirmation();
                        new UserConfirmation(context.getConsoleWrapper(), "This tool is not able to assert if the scanner's deployments found are compatible with the target server, skip scanner's deployments migration?", "yes/no?", (UserConfirmation.ResultHandler)migrateUserConfirmation).execute();
                        boolean bl = migrateDeployments = migrateUserConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                        if (migrateDeployments && deployments.size() > 1) {
                            BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                            new UserConfirmation(context.getConsoleWrapper(), "Migrate all scanner's deployments found?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                            confirmEachDeployment = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                        }
                    }
                    for (Path deployment : deployments) {
                        boolean migrateDeployment;
                        if (confirmEachDeployment) {
                            BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                            new UserConfirmation(context.getConsoleWrapper(), "Migrate scanner's deployment '" + deployment + "'?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                            migrateDeployment = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.YES;
                        } else {
                            migrateDeployment = migrateDeployments;
                        }
                        if (!migrateDeployment) continue;
                        Path sourcePath = sourceDeploymentsDir.resolve(deployment);
                        Path targetPath = targetDeploymentsDir.resolve(deployment);
                        ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder("deployments.migrate-scanner-deployment").addAttribute("source", sourcePath.toString()).addAttribute("target", targetPath.toString()).build();
                        context.execute(subtaskName, subtaskContext -> new CopyPath(sourcePath, targetPath).run(subtaskContext));
                    }
                }
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }
}

