/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.util.Collection;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.WildFlyServer10;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class ServerConfigurationsMigration<S extends Server, C, T extends ManageableServerConfiguration> {
    private final ServerMigrationTaskName taskName;
    private final SourceConfigurations<S, C> sourceConfigurations;
    private final ServerConfigurationMigration<C, T> configFileMigration;

    public ServerConfigurationsMigration(SourceConfigurations<S, C> sourceConfigurations, ServerConfigurationMigration<C, T> configFileMigration) {
        this.sourceConfigurations = sourceConfigurations;
        this.configFileMigration = configFileMigration;
        this.taskName = new ServerMigrationTaskName.Builder(configFileMigration.getConfigType() + "-configurations").build();
    }

    public ServerMigrationTask getServerMigrationTask(S source, WildFlyServer10 target, JBossServerConfiguration.Type targetConfigurationType) {
        return new Task<C, T>(this.getServerMigrationTaskName(), this.sourceConfigurations.getConfigurations(source, target), target, targetConfigurationType, this.configFileMigration);
    }

    protected ServerMigrationTaskName getServerMigrationTaskName() {
        return this.taskName;
    }

    public static interface SourceConfigurations<S extends Server, C> {
        public Collection<C> getConfigurations(S var1, WildFlyServer10 var2);
    }

    protected static class Task<S, T extends ManageableServerConfiguration>
    implements ServerMigrationTask {
        private final ServerMigrationTaskName name;
        private final Collection<S> sourceConfigs;
        private final JBossServerConfiguration.Type targetConfigurationType;
        private final WildFlyServer10 target;
        private final ServerConfigurationMigration<S, T> configFileMigration;

        protected Task(ServerMigrationTaskName name, Collection<S> sourceConfigs, WildFlyServer10 target, JBossServerConfiguration.Type targetConfigurationType, ServerConfigurationMigration<S, T> configFileMigration) {
            this.name = name;
            this.sourceConfigs = sourceConfigs;
            this.targetConfigurationType = targetConfigurationType;
            this.target = target;
            this.configFileMigration = configFileMigration;
        }

        public ServerMigrationTaskName getName() {
            return this.name;
        }

        public ServerMigrationTaskResult run(TaskContext taskContext) {
            ConsoleWrapper consoleWrapper = taskContext.getConsoleWrapper();
            consoleWrapper.printf("%n", new Object[0]);
            taskContext.getLogger().infof("Retrieving source's %s configurations...", (Object)this.configFileMigration.getConfigType());
            if (!this.sourceConfigs.isEmpty()) {
                for (S sourceConfig : this.sourceConfigs) {
                    taskContext.getLogger().infof("%s", sourceConfig);
                }
            } else {
                taskContext.getLogger().infof("No source's %s configurations found.", (Object)this.configFileMigration.getConfigType());
                return ServerMigrationTaskResult.SKIPPED;
            }
            if (taskContext.isInteractive()) {
                BasicResultHandlers.UserConfirmation resultHandler = new BasicResultHandlers.UserConfirmation();
                new UserConfirmation(consoleWrapper, "Migrate all configurations?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), (UserConfirmation.ResultHandler)resultHandler).execute();
                switch (resultHandler.getResult()) {
                    case NO: {
                        this.confirmAllConfigs(this.sourceConfigs, this.targetConfigurationType, this.target, taskContext);
                        break;
                    }
                    case YES: {
                        this.migrateAllConfigs(this.sourceConfigs, this.targetConfigurationType, this.target, taskContext);
                        break;
                    }
                    case ERROR: {
                        return this.run(taskContext);
                    }
                    default: {
                        throw new ServerMigrationFailureException("unexpected user interaction result");
                    }
                }
            } else {
                this.migrateAllConfigs(this.sourceConfigs, this.targetConfigurationType, this.target, taskContext);
            }
            return taskContext.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        }

        protected void migrateAllConfigs(Collection<S> sourceConfigs, JBossServerConfiguration.Type targetConfigurationType, WildFlyServer10 target, TaskContext taskContext) {
            for (S sourceConfig : sourceConfigs) {
                taskContext.execute(this.configFileMigration.getServerMigrationTask(sourceConfig, targetConfigurationType, target));
            }
        }

        protected void confirmAllConfigs(Collection<S> sourceConfigs, JBossServerConfiguration.Type targetConfigurationType, WildFlyServer10 target, TaskContext taskContext) {
            for (S sourceConfig : sourceConfigs) {
                this.confirmConfig(sourceConfig, targetConfigurationType, target, taskContext);
            }
        }

        protected void confirmConfig(final S sourceConfig, final JBossServerConfiguration.Type targetConfigurationType, final WildFlyServer10 target, final TaskContext taskContext) {
            UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

                public void onNo() {
                }

                public void onYes() {
                    taskContext.execute(configFileMigration.getServerMigrationTask(sourceConfig, targetConfigurationType, target));
                }

                public void onError() {
                    this.confirmConfig(sourceConfig, targetConfigurationType, target, taskContext);
                }
            };
            ConsoleWrapper consoleWrapper = taskContext.getConsoleWrapper();
            new UserConfirmation(consoleWrapper, "Migrate configuration " + sourceConfig + " ?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
        }
    }
}

