/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.management.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class MigrateSubsystemResourceSubtaskBuilder<S>
extends ManageableResourceLeafTask.Builder<S, SubsystemResource> {
    private String subsystem;

    public MigrateSubsystemResourceSubtaskBuilder(String subsystem) {
        this.subsystem = subsystem;
        this.runBuilder(params -> context -> this.migrateConfiguration((SubsystemResource)params.getResource(), context));
    }

    protected ServerMigrationTaskResult migrateConfiguration(SubsystemResource subsystemResource, TaskContext taskContext) {
        ModelNode result;
        String configName = subsystemResource.getResourceAbsoluteName();
        taskContext.getLogger().debugf("Migrating subsystem config %s...", (Object)configName);
        ModelNode op = Util.createEmptyOperation((String)"migrate", (PathAddress)subsystemResource.getResourcePathAddress());
        try {
            result = subsystemResource.getServerConfiguration().getModelControllerClient().execute(op);
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("Subsystem config " + configName + " migration failed", (Throwable)e);
        }
        taskContext.getLogger().tracef("Op result: %s", (Object)result.asString());
        String outcome = result.get("outcome").asString();
        if (!"success".equals(outcome)) {
            throw new ServerMigrationFailureException("Subsystem config " + configName + " migration failed: " + result.get("migration-error").asString());
        }
        ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().success();
        ArrayList<String> migrateWarnings = new ArrayList<String>();
        if (result.get("result").hasDefined("migration-warnings")) {
            for (ModelNode modelNode : result.get("result").get("migration-warnings").asList()) {
                migrateWarnings.add(modelNode.asString());
            }
        }
        this.processWarnings(migrateWarnings, subsystemResource, taskContext);
        if (migrateWarnings.isEmpty()) {
            taskContext.getLogger().infof("Subsystem config %s migrated.", (Object)configName);
        } else {
            taskContext.getLogger().infof("Subsystem config %s migrated with warnings: %s", (Object)configName, migrateWarnings);
            resultBuilder.addAttribute("migration-warnings", migrateWarnings);
        }
        if (subsystemResource.getResourceConfiguration() != null) {
            subsystemResource.getParentResource().removeChildResource(SubsystemResource.RESOURCE_TYPE, subsystemResource.getResourceName());
            taskContext.getLogger().debugf("Subsystem config %s removed after migration.", (Object)configName);
        }
        return resultBuilder.build();
    }

    protected void processWarnings(List<String> migrateWarnings, SubsystemResource subsystemResource, TaskContext taskContext) {
    }

    public String getSubsystem() {
        return this.subsystem;
    }
}

