/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.paths;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.MigrateResolvablePathTaskBuilder;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.jboss.XmlConfigurationMigration;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public class VaultPathsMigration
implements XmlConfigurationMigration.Component {
    private static final Set<String> ELEMENT_LOCAL_NAMES = Collections.singleton("vault-option");
    private String keystoreURL;
    private String encFileDir;

    protected VaultPathsMigration() {
    }

    public Set<String> getElementLocalNames() {
        return ELEMENT_LOCAL_NAMES;
    }

    public void processElement(XMLStreamReader reader, JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext context) throws IOException {
        String namespaceURI = reader.getNamespaceURI();
        if (namespaceURI == null || !namespaceURI.startsWith("urn:jboss:domain:")) {
            return;
        }
        String optionName = reader.getAttributeValue(null, "name");
        if ("KEYSTORE_URL".equals(optionName)) {
            this.keystoreURL = reader.getAttributeValue(null, "value");
        } else if ("ENC_FILE_DIR".equals(optionName)) {
            this.encFileDir = reader.getAttributeValue(null, "value");
        }
    }

    public void afterProcessingElements(JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext taskContext) {
        taskContext.execute(((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(taskContext.getTaskName().getName() + ".vault")).skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet())).runnable(context -> {
            if (this.keystoreURL != null) {
                context.execute(new MigrateResolvablePathTaskBuilder().name(context.getTaskName().getName() + ".KEYSTORE_URL").path(ResolvablePath.fromPathExpression((String)this.keystoreURL)).source(sourceConfiguration).target(targetConfiguration).build());
            }
            if (this.encFileDir != null) {
                context.execute(new MigrateResolvablePathTaskBuilder().name(context.getTaskName().getName() + ".ENC_FILE_DIR").path(ResolvablePath.fromPathExpression((String)this.encFileDir)).source(sourceConfiguration).target(targetConfiguration).build());
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        })).build());
    }

    public static class Factory
    implements XmlConfigurationMigration.ComponentFactory {
        public XmlConfigurationMigration.Component newComponent() {
            return new VaultPathsMigration();
        }
    }
}

