/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.wfly10.config.task.subsystem.LegacyExtension;
import org.jboss.migration.wfly10.config.task.subsystem.LegacySubsystem;

public class LegacyExtensionBuilder {
    private final List<Subsystem> subsystems = new ArrayList<Subsystem>();
    private final String name;

    public LegacyExtensionBuilder(String name) {
        this.name = name;
    }

    public LegacyExtensionBuilder subsystem(String subsystemName) {
        return this.subsystem(subsystemName, null);
    }

    public LegacyExtensionBuilder subsystem(String subsystemName, String namespaceWithoutVersion) {
        this.subsystems.add(new Subsystem(subsystemName, namespaceWithoutVersion));
        return this;
    }

    public LegacyExtension build() {
        LegacyExtension extension = new LegacyExtension(this.name);
        for (Subsystem subsystem : this.subsystems) {
            extension.subsystems.add(new LegacySubsystem(subsystem.name, subsystem.namespaceWithoutVersion, extension));
        }
        return extension;
    }

    private static class Subsystem {
        final String name;
        final String namespaceWithoutVersion;

        public Subsystem(String name, String namespaceWithoutVersion) {
            this.name = name;
            this.namespaceWithoutVersion = namespaceWithoutVersion == null ? "urn:jboss:domain:" + name : namespaceWithoutVersion;
        }
    }
}

