/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public abstract class SetDefaultHostResponseHeader<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-response-header";
    private static final String SERVER_NAME = "default-server";
    private static final String HOST_NAME = "default-host";
    private static final String FILTER_REF = "filter-ref";
    private static final String CONFIGURATION = "configuration";
    private static final String FILTER = "filter";
    private static final String RESPONSE_HEADER = "response-header";
    private static final String HEADER_NAME = "header-name";
    private static final String HEADER_VALUE = "header-value";
    protected final String filterName;
    protected final String headerName;

    public SetDefaultHostResponseHeader(String filterName, String headerName) {
        this.subtaskName("add-response-header." + filterName);
        this.filterName = filterName;
        this.headerName = headerName;
    }

    protected abstract String getHeaderValue(boolean var1, ModelNode var2, SubsystemResource var3, TaskContext var4, TaskEnvironment var5);

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress configPathAddress = subsystemResource.getResourcePathAddress();
        PathAddress serverPathAddress = configPathAddress.append(new PathElement[]{PathElement.pathElement((String)"server", (String)SERVER_NAME)});
        if (!config.hasDefined(new String[]{"server", SERVER_NAME})) {
            context.getLogger().debugf("Skipping task, server '%s' not found in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode server = config.get(new String[]{"server", SERVER_NAME});
        PathAddress defaultHostPathAddress = serverPathAddress.append(new PathElement[]{PathElement.pathElement((String)"host", (String)HOST_NAME)});
        if (!server.hasDefined(new String[]{"host", HOST_NAME})) {
            context.getLogger().debugf("Skipping task, host '%s' not found in Undertow's config %s", (Object)defaultHostPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        boolean headerDefined = config.hasDefined(new String[]{CONFIGURATION, FILTER, RESPONSE_HEADER, this.filterName});
        String headerValue = this.getHeaderValue(headerDefined, config, subsystemResource, context, taskEnvironment);
        if (headerValue == null) {
            context.getLogger().debugf("Skipping task, no header-value to set", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        PathAddress responseHeaderPathAddress = configPathAddress.append(CONFIGURATION, FILTER).append(RESPONSE_HEADER, this.filterName);
        if (!headerDefined) {
            ModelNode op;
            if (!config.hasDefined(new String[]{CONFIGURATION, FILTER})) {
                op = Util.createAddOperation((PathAddress)configPathAddress.append(CONFIGURATION, FILTER));
                subsystemResource.getServerConfiguration().executeManagementOperation(op);
            }
            op = Util.createAddOperation((PathAddress)responseHeaderPathAddress);
            op.get(HEADER_NAME).set(this.headerName);
            op.get(HEADER_VALUE).set(headerValue);
            subsystemResource.getServerConfiguration().executeManagementOperation(op);
            if (!server.get(new String[]{"host", HOST_NAME}).hasDefined(new String[]{FILTER_REF, this.filterName})) {
                PathAddress filterRefPathAddress = defaultHostPathAddress.append(FILTER_REF, this.filterName);
                subsystemResource.getServerConfiguration().executeManagementOperation(Util.createAddOperation((PathAddress)filterRefPathAddress));
            }
        } else {
            ModelNode op = Util.getWriteAttributeOperation((PathAddress)responseHeaderPathAddress, (String)HEADER_VALUE, (String)headerValue);
            subsystemResource.getServerConfiguration().executeManagementOperation(op);
        }
        context.getLogger().debugf("Response header '%s' set as '%s: %s' in Undertow's config %s", new Object[]{this.filterName, this.headerName, headerValue, configPathAddress.toCLIStyleString()});
        return new ServerMigrationTaskResult.Builder().success().addAttribute(HEADER_NAME, (Object)this.headerName).addAttribute(HEADER_VALUE, (Object)headerValue).build();
    }
}

