/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.InterfaceResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;

public class RemoveUnsecureInterface<S>
extends ManageableServerConfigurationLeafTask.Builder<S> {
    public RemoveUnsecureInterface() {
        this.name("interface.unsecure.remove");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Unsecure interface removal task starting...", new Object[0]));
        this.runBuilder(params -> context -> {
            InterfaceResource resource = params.getServerConfiguration().getInterfaceResource("unsecure");
            if (resource == null) {
                context.getLogger().debugf("Unsecure interface not found, skipping task.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            resource.removeResource();
            context.getLogger().infof("Interface %s removed.", (Object)resource.getResourceAbsoluteName());
            return ServerMigrationTaskResult.SUCCESS;
        });
        this.afterRun(context -> context.getLogger().debugf("Unsecure interface removal task done.", new Object[0]));
    }
}

