/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFiles;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.ExtensionBuilder;
import org.jboss.migration.wfly10.config.task.subsystem.Subsystem;

public class RemoveUnsupportedSubsystems<S>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<S> {
    public static final ServerMigrationTaskName XML_CONFIG_SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("subsystems.remove-unsupported-subsystems").build();
    public static final String SERVER_MIGRATION_TASK_NAME_REMOVE_SUBSYSTEM = XML_CONFIG_SERVER_MIGRATION_TASK_NAME.getName() + ".remove-unsupported-subsystem";
    public static final String SERVER_MIGRATION_TASK_NAME_REMOVE_EXTENSION = XML_CONFIG_SERVER_MIGRATION_TASK_NAME.getName() + ".remove-unsupported-extension";
    public static final String SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE = "module";
    public static final String SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_NAMESPACE = "namespace";
    private final List<Extension> supportedExtensions;

    protected RemoveUnsupportedSubsystems(Builder<S> builder) {
        this.supportedExtensions = Collections.unmodifiableList(((Builder)builder).supportedExtensions);
    }

    @Override
    public ServerMigrationTask getTask(final S source, final JBossServerConfiguration targetConfigurationPath) {
        ServerMigrationTask task = new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return XML_CONFIG_SERVER_MIGRATION_TASK_NAME;
            }

            public ServerMigrationTaskResult run(TaskContext context) {
                context.getLogger().debugf("Searching for extensions and subsystems not supported by the target server...", new Object[0]);
                RemoveUnsupportedSubsystems.this.removeExtensionsAndSubsystems(source, targetConfigurationPath.getPath(), context);
                if (!context.hasSucessfulSubtasks()) {
                    context.getLogger().debugf("No unsupported extensions and subsystems found.", new Object[0]);
                }
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
        return new SkippableByEnvServerMigrationTask(task);
    }

    protected void removeExtensionsAndSubsystems(S source, Path xmlConfigurationPath, TaskContext context) {
        List<Extension> migrationExtensions = this.getMigrationExtensions(context.getMigrationEnvironment());
        List<Subsystem> migrationSubsystems = this.getMigrationSubsystems(migrationExtensions, context.getMigrationEnvironment());
        final HashSet extensionsRemoved = new HashSet();
        final HashSet subsystemsRemoved = new HashSet();
        XMLFileFilter extensionsFilter = (startElement, xmlEventReader, xmlEventWriter, xmlEventFactory) -> {
            if (startElement.getName().getLocalPart().equals("extension")) {
                Attribute moduleAttr = startElement.getAttributeByName(new QName(SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE));
                final String moduleName = moduleAttr.getValue();
                for (Extension extension : migrationExtensions) {
                    if (!extension.getName().equals(moduleName)) continue;
                    return XMLFileFilter.Result.ADD;
                }
                final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder(SERVER_MIGRATION_TASK_NAME_REMOVE_EXTENSION).addAttribute(SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_MODULE, moduleName).build();
                ServerMigrationTask subtask = new ServerMigrationTask(){

                    public ServerMigrationTaskName getName() {
                        return subtaskName;
                    }

                    public ServerMigrationTaskResult run(TaskContext context1) {
                        context1.getLogger().debugf("Extension with module %s removed.", (Object)moduleName);
                        extensionsRemoved.add(moduleName);
                        return ServerMigrationTaskResult.SUCCESS;
                    }
                };
                context.execute(subtask);
                return XMLFileFilter.Result.REMOVE;
            }
            return XMLFileFilter.Result.NOT_APPLICABLE;
        };
        XMLFileFilter subsystemsFilter = (startElement, xmlEventReader, xmlEventWriter, xmlEventFactory) -> {
            if (startElement.getName().getLocalPart().equals("subsystem")) {
                final String namespaceURI = startElement.getName().getNamespaceURI();
                for (Subsystem subsystem : migrationSubsystems) {
                    String namespaceWithoutVersion = subsystem.getNamespaceWithoutVersion();
                    if (namespaceWithoutVersion == null || !namespaceURI.startsWith(namespaceWithoutVersion + ':')) continue;
                    return XMLFileFilter.Result.ADD;
                }
                final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder(SERVER_MIGRATION_TASK_NAME_REMOVE_SUBSYSTEM).addAttribute(SERVER_MIGRATION_TASK_NAME_ATTRIBUTE_NAMESPACE, namespaceURI).build();
                ServerMigrationTask subtask = new ServerMigrationTask(){

                    public ServerMigrationTaskName getName() {
                        return subtaskName;
                    }

                    public ServerMigrationTaskResult run(TaskContext context12) {
                        context12.getLogger().debugf("Subsystem with namespace %s removed.", (Object)namespaceURI);
                        subsystemsRemoved.add(namespaceURI);
                        return ServerMigrationTaskResult.SUCCESS;
                    }
                };
                context.execute(subtask);
                return XMLFileFilter.Result.REMOVE;
            }
            return XMLFileFilter.Result.NOT_APPLICABLE;
        };
        XMLFiles.filter((Path)xmlConfigurationPath, (XMLFileFilter[])new XMLFileFilter[]{extensionsFilter, subsystemsFilter});
        context.getLogger().infof("Removed the following unsupported extensions: %s", extensionsRemoved);
        context.getLogger().infof("Removed the following unsupported subsystems: %s", subsystemsRemoved);
    }

    private List<Extension> getMigrationExtensions(MigrationEnvironment migrationEnvironment) {
        List removedByEnv = migrationEnvironment.getPropertyAsList("extensions.remove");
        if (removedByEnv == null || removedByEnv.isEmpty()) {
            return this.supportedExtensions;
        }
        ArrayList<Extension> migrationExtensions = new ArrayList<Extension>();
        for (Extension supportedExtension : this.supportedExtensions) {
            if (removedByEnv.contains(supportedExtension.getName())) continue;
            migrationExtensions.add(supportedExtension);
        }
        return migrationExtensions;
    }

    private List<Subsystem> getMigrationSubsystems(List<Extension> migrationExtensions, MigrationEnvironment migrationEnvironment) {
        List removedByEnv = migrationEnvironment.getPropertyAsList("subsystems.remove");
        ArrayList<Subsystem> migrationSubsystems = new ArrayList<Subsystem>();
        for (Extension extension : migrationExtensions) {
            for (Subsystem subsystem : extension.getSubsystems()) {
                if (removedByEnv != null && removedByEnv.contains(subsystem.getName())) continue;
                migrationSubsystems.add(subsystem);
            }
        }
        return migrationSubsystems;
    }

    public static class Builder<S> {
        private final List<Extension> supportedExtensions = new ArrayList<Extension>();

        public Builder<S> extension(Extension extension) {
            this.supportedExtensions.add(extension);
            return this;
        }

        public Builder<S> extension(ExtensionBuilder extensionBuilder) {
            this.supportedExtensions.add(extensionBuilder.build());
            return this;
        }

        public Builder<S> extensions(Collection<Extension> extensions) {
            this.supportedExtensions.addAll(extensions);
            return this;
        }

        public RemoveUnsupportedSubsystems<S> build() {
            return new RemoveUnsupportedSubsystems(this);
        }
    }
}

