/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFiles;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class RemoveUnsupportedExtensions<S extends JBossServer<S>>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<JBossServerConfiguration<S>> {
    public static final String TASK_NAME = "extensions.remove-unsupported-extensions";
    public static final String SUBTASK_NAME = "extensions.remove-unsupported-extensions.remove-unsupported-extension";
    public static final String SUBTASK_NAME_ATTRIBUTE_MODULE = "module";

    @Override
    public ServerMigrationTask getTask(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath) {
        return ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(TASK_NAME)).skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet())).runnable(context -> {
            context.getLogger().debugf("Searching for extensions not supported by the target server...", new Object[0]);
            this.removeExtensions(source, targetConfigurationPath, context);
            if (!context.hasSucessfulSubtasks()) {
                context.getLogger().debugf("No unsupported extensions found.", new Object[0]);
            }
            return ServerMigrationTaskResult.SUCCESS;
        })).build();
    }

    protected void removeExtensions(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath, TaskContext context) {
        HashSet accepted = new HashSet(targetConfigurationPath.getServer().getExtensions().getExtensionModuleNames());
        MigrationEnvironment environment = context.getMigrationEnvironment();
        accepted.addAll(environment.getPropertyAsList("extensions.includes", Collections.emptyList()));
        accepted.removeAll(environment.getPropertyAsList("extensions.excludes", Collections.emptyList()));
        HashSet removed = new HashSet();
        XMLFileFilter extensionsFilter = (startElement, xmlEventReader, xmlEventWriter, xmlEventFactory) -> {
            if (startElement.getName().getLocalPart().equals("extension")) {
                Attribute moduleAttr = startElement.getAttributeByName(new QName(SUBTASK_NAME_ATTRIBUTE_MODULE));
                String moduleName = moduleAttr.getValue();
                if (accepted.contains(moduleName)) {
                    return XMLFileFilter.Result.ADD;
                }
                ServerMigrationTask subtask = ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(new ServerMigrationTaskName.Builder(SUBTASK_NAME).addAttribute(SUBTASK_NAME_ATTRIBUTE_MODULE, moduleName).build())).runnable(subtaskContext -> {
                    subtaskContext.getLogger().debugf("Extension with module '%s' removed.", (Object)moduleName);
                    removed.add(moduleName);
                    return ServerMigrationTaskResult.SUCCESS;
                })).build();
                context.execute(subtask);
                return XMLFileFilter.Result.REMOVE;
            }
            return XMLFileFilter.Result.NOT_APPLICABLE;
        };
        XMLFiles.filter((Path)targetConfigurationPath.getPath(), (XMLFileFilter[])new XMLFileFilter[]{extensionsFilter});
        if (!removed.isEmpty()) {
            context.getLogger().infof("Unsupported extensions removed: %s", removed);
        }
    }

    public static interface EnvironmentProperties {
        public static final String PREFIX = "extensions.";
        public static final String INCLUDES = "extensions.includes";
        public static final String EXCLUDES = "extensions.excludes";
    }
}

