/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.InterfaceResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;

public class RemoveUnsecureInterface<S>
extends ManageableServerConfigurationLeafTask.Builder<S> {
    public RemoveUnsecureInterface() {
        this.name("interface.unsecure.remove");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Removing interface unsecure...", new Object[0]));
        this.runBuilder(params -> context -> {
            InterfaceResource resource = params.getServerConfiguration().getInterfaceResource("unsecure");
            if (resource == null) {
                context.getLogger().debugf("Interface unsecure not found, skipping task.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            resource.removeResource();
            context.getLogger().infof("Interface unsecure removed.", new Object[0]);
            return ServerMigrationTaskResult.SUCCESS;
        });
    }
}

