/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.jberet;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;

public class AddBatchJBeretSubsystemResource<S>
extends AddSubsystemResourceSubtaskBuilder<S> {
    private static final String DEFAULT_JOB_REPOSITORY_ATTR_NAME = "default-job-repository";
    private static final String DEFAULT_JOB_REPOSITORY_ATTR_VALUE = "in-memory";
    private static final String DEFAULT_THREAD_POOL_ATTR_NAME = "default-thread-pool";
    private static final String DEFAULT_THREAD_POOL_ATTR_VALUE = "batch";
    private static final String IN_MEMORY_JOB_REPOSITORY = "in-memory-job-repository";
    private static final String THREAD_POOL = "thread-pool";
    private static final String MAX_THREADS = "max-threads";
    private static final String MAX_THREADS_VALUE = "10";
    private static final String KEEPALIVE_TIME = "keepalive-time";
    private static final String KEEPALIVE_TIME_TIME_ATTR_NAME = "time";
    private static final String KEEPALIVE_TIME_TIME_ATTR_VALUE = "30";
    private static final String KEEPALIVE_TIME_UNIT_ATTR_NAME = "unit";
    private static final String KEEPALIVE_TIME_UNIT_ATTR_VALUE = "seconds";

    protected AddBatchJBeretSubsystemResource() {
        super("batch-jberet");
    }

    @Override
    protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
        SubsystemResource.Parent parentResource = params.getResource();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress subsystemPathAddress = parentResource.getSubsystemResourcePathAddress(this.getSubsystem());
        ModelNode subsystemAddOperation = Util.createAddOperation((PathAddress)subsystemPathAddress);
        subsystemAddOperation.get(DEFAULT_JOB_REPOSITORY_ATTR_NAME).set(DEFAULT_JOB_REPOSITORY_ATTR_VALUE);
        subsystemAddOperation.get(DEFAULT_THREAD_POOL_ATTR_NAME).set(DEFAULT_THREAD_POOL_ATTR_VALUE);
        compositeOperationBuilder.addStep(subsystemAddOperation);
        PathAddress jobReporsitoryPathAddress = subsystemPathAddress.append(IN_MEMORY_JOB_REPOSITORY, DEFAULT_JOB_REPOSITORY_ATTR_VALUE);
        ModelNode jobReporsitoryAddOperation = Util.createAddOperation((PathAddress)jobReporsitoryPathAddress);
        compositeOperationBuilder.addStep(jobReporsitoryAddOperation);
        PathAddress threadPoolPathAddress = subsystemPathAddress.append(THREAD_POOL, DEFAULT_THREAD_POOL_ATTR_VALUE);
        ModelNode threadPoolAddOperation = Util.createAddOperation((PathAddress)threadPoolPathAddress);
        threadPoolAddOperation.get(MAX_THREADS).set(MAX_THREADS_VALUE);
        ModelNode keepAliveTime = new ModelNode();
        keepAliveTime.get(KEEPALIVE_TIME_TIME_ATTR_NAME).set(KEEPALIVE_TIME_TIME_ATTR_VALUE);
        keepAliveTime.get(KEEPALIVE_TIME_UNIT_ATTR_NAME).set(KEEPALIVE_TIME_UNIT_ATTR_VALUE);
        threadPoolAddOperation.get(KEEPALIVE_TIME).set(keepAliveTime);
        compositeOperationBuilder.addStep(threadPoolAddOperation);
        parentResource.getServerConfiguration().executeManagementOperation(compositeOperationBuilder.build().getOperation());
    }
}

