/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.CopyPath;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public class MigrateContentDir<S extends JBossServer<S>>
extends SimpleComponentTask.Builder {
    protected MigrateContentDir(String contentsName, Path sourceContentDir, Path targetContentDir) {
        this.name("contents." + contentsName + ".migrate-content-dir");
        this.skipPolicies(new TaskSkipPolicy[]{TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet(), context -> !Files.isDirectory(sourceContentDir, new LinkOption[0])});
        this.runnable(context -> {
            List contents;
            context.getLogger().debugf("Migrating source's %s content...", (Object)contentsName);
            try {
                context.getLogger().debugf("Retrieving %s content from '%s'...", (Object)contentsName, (Object)sourceContentDir);
                contents = Files.find(sourceContentDir, 3, (path, basicFileAttributes) -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().equals("content"), new FileVisitOption[0]).map(path -> sourceContentDir.relativize((Path)path)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new ServerMigrationFailureException("Failed to read content from " + sourceContentDir, (Throwable)e);
            }
            if (contents.isEmpty()) {
                context.getLogger().infof("No source's %s content found to migrate.", (Object)contentsName);
                return ServerMigrationTaskResult.SKIPPED;
            }
            context.getLogger().debugf("Source's %s content found: %s", (Object)contentsName, contents);
            for (Path content : contents) {
                ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder("contents." + contentsName + ".migrate-content").addAttribute("path", content.toString()).build();
                context.execute(subtaskName, (TaskRunnable)new CopyPath(sourceContentDir.resolve(content), targetContentDir.resolve(content)));
            }
            context.getLogger().infof("Source's %s content migrated.", (Object)contentsName);
            return ServerMigrationTaskResult.SUCCESS;
        });
    }
}

