/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.securitymanager;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ProfileResource;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;

public class AddSecurityManagerSubsystemResource<S>
extends AddSubsystemResourceSubtaskBuilder<S> {
    private static final String DEPLOYMENT_PERMISSIONS = "deployment-permissions";
    private static final String DEPLOYMENT_PERMISSIONS_NAME = "default";
    private static final String MAXIMUM_PERMISSIONS = "maximum-permissions";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String CLASS_ATTR_VALUE = "java.security.AllPermission";

    protected AddSecurityManagerSubsystemResource() {
        super("security-manager");
        this.skipPolicyBuilder(buildParameters -> context -> ((SubsystemResource.Parent)buildParameters.getResource()).getResourceType() == ProfileResource.RESOURCE_TYPE && ((SubsystemResource.Parent)buildParameters.getResource()).getResourceName().equals("load-balancer"));
    }

    @Override
    protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
        super.addConfiguration(params, taskContext);
        SubsystemResource.Parent parentResource = params.getResource();
        PathAddress subsystemPathAddress = parentResource.getSubsystemResourcePathAddress(this.getSubsystem());
        PathAddress deploymentPermissionsPathAddress = subsystemPathAddress.append(DEPLOYMENT_PERMISSIONS, DEPLOYMENT_PERMISSIONS_NAME);
        ModelNode deploymentPermissionsAddOperation = Util.createAddOperation((PathAddress)deploymentPermissionsPathAddress);
        ModelNode maximumPermissions = new ModelNode();
        maximumPermissions.get(CLASS_ATTR_NAME).set(CLASS_ATTR_VALUE);
        deploymentPermissionsAddOperation.get(MAXIMUM_PERMISSIONS).add(maximumPermissions);
        parentResource.getServerConfiguration().executeManagementOperation(deploymentPermissionsAddOperation);
    }
}

