/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.DeploymentOverlayResource;
import org.jboss.migration.wfly10.config.management.DeploymentResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class RemoveDeployments<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    public RemoveDeployments() {
        this.name("deployments.remove");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().infof("Deployments removal starting...", new Object[0]));
        ManageableServerConfigurationCompositeSubtasks.Builder subtasks = (ManageableServerConfigurationCompositeSubtasks.Builder)((ManageableServerConfigurationCompositeSubtasks.Builder)new ManageableServerConfigurationCompositeSubtasks.Builder().subtask(DeploymentResource.class, new RemoveDeploymentSubtask())).subtask(DeploymentOverlayResource.class, new RemoveDeploymentOverlaySubtask());
        this.subtasks(subtasks);
        this.afterRun(context -> context.getLogger().infof("Deployments removal done.", new Object[0]));
    }

    public static class RemoveDeploymentOverlaySubtask<S>
    extends ManageableResourceLeafTask.Builder<S, DeploymentOverlayResource> {
        protected RemoveDeploymentOverlaySubtask() {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployment-overlay." + ((DeploymentOverlayResource)parameters.getResource()).getResourceName() + ".remove").build());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                DeploymentOverlayResource resource = (DeploymentOverlayResource)params.getResource();
                resource.removeResource();
                context.getLogger().infof("Removed deployment overlay configuration %s", (Object)resource.getResourceAbsoluteName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }

    public static class RemoveDeploymentSubtask<S>
    extends ManageableResourceLeafTask.Builder<S, DeploymentResource> {
        protected RemoveDeploymentSubtask() {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployment." + ((DeploymentResource)parameters.getResource()).getResourceName() + ".remove").build());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                DeploymentResource resource = (DeploymentResource)params.getResource();
                resource.removeResource();
                context.getLogger().infof("Removed deployment configuration %s", (Object)resource.getResourceAbsoluteName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

