/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly9;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.JBossServer;
import org.jboss.migration.core.ManifestProductInfo;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.wfly9.WildFly9Server;

public class WildFly9ServerProvider
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir, MigrationEnvironment migrationEnvironment) throws IllegalArgumentException, IOException {
        Path manifestPath = JBossServer.getModulesDir((Path)baseDir).resolve("system").resolve("layers").resolve("base").resolve("org").resolve("jboss").resolve("as").resolve("product").resolve("wildfly-full").resolve("dir").resolve("META-INF").resolve("MANIFEST.MF");
        ManifestProductInfo productInfo = ManifestProductInfo.from((Path)manifestPath);
        return productInfo;
    }

    protected String getProductNameRegex() {
        return "WildFly Full";
    }

    protected String getProductVersionRegex() {
        return "9\\..*";
    }

    protected Server constructServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        return new WildFly9Server(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    public String getName() {
        return "WildFly Full 9.x";
    }
}

