/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import __redirected.__JAXPRedirected;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogManager;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.log.JDKModuleLogger;

public final class Main {
    private Main() {
    }

    public static String getJarName() {
        return "jboss-modules";
    }

    public static String getVersionString() {
        return "1.0.0.Beta15";
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]\n");
        System.out.println("where options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -modulepath <search path of directories>");
        System.out.println("    -mp <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -config <config-location>");
        System.out.println("                  The location of the module configuration.  Either -mp or -config");
        System.out.println("                  may be specified, but not both");
        System.out.println("    -logmodule <module-name>");
        System.out.println("                  The module to use to load the system logmanager");
        System.out.println("    -jaxpmodule <module-name>");
        System.out.println("                  The default JAXP implementation to use of the JDK.");
        System.out.println("    -version      Print version and exit\n");
        System.out.println("and module-spec is a valid module specification string");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        Module module;
        int argsLen = args.length;
        String[] moduleArgs = null;
        String modulePath = null;
        String configPath = null;
        ModuleIdentifier moduleIdentifier = null;
        ModuleIdentifier logManagerModuleIdentifier = null;
        ModuleIdentifier jaxpModuleIdentifier = null;
        int argsLength = argsLen;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("Module loader " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        if (configPath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-config".equals(arg)) {
                        if (configPath != null) {
                            System.err.println("Config file path may only be specified once");
                            System.exit(1);
                        }
                        if (modulePath != null) {
                            System.err.println("Module path may not be specified with config path");
                            System.exit(1);
                        }
                        configPath = args[++i];
                        continue;
                    }
                    if ("-logmodule".equals(arg)) {
                        logManagerModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    if ("-jaxpmodule".equals(arg)) {
                        jaxpModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    System.err.printf("Invalid option '%s'\n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                moduleIdentifier = ModuleIdentifier.fromString(arg);
                int cnt = argsLen - i - 1;
                moduleArgs = new String[cnt];
                System.arraycopy(args, i + 1, moduleArgs, 0, cnt);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (moduleIdentifier == null) {
            System.err.println("No module specified");
            Main.usage();
            System.exit(1);
        }
        ModuleLoader loader = configPath != null ? ModuleXmlParser.parseModuleConfigXml(new File(configPath)) : DefaultBootModuleLoaderHolder.INSTANCE;
        Module.initBootModuleLoader(loader);
        if (logManagerModuleIdentifier != null) {
            ModuleClassLoader classLoader = loader.loadModule(logManagerModuleIdentifier).getClassLoaderPrivate();
            InputStream stream = classLoader.getResourceAsStream("META-INF/services/java.util.logging.LogManager");
            if (stream != null) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                    String name = null;
                    while ((line = reader.readLine()) != null) {
                        int i = line.indexOf(35);
                        if (i != -1) {
                            line = line.substring(0, i);
                        }
                        if ((line = line.trim()).length() == 0) continue;
                        name = line;
                        break;
                    }
                    if (name != null) {
                        ClassLoader old;
                        block36: {
                            System.setProperty("java.util.logging.manager", name);
                            old = Main.setContextClassLoader(classLoader);
                            try {
                                if (LogManager.getLogManager().getClass() == LogManager.class) {
                                    System.err.println("WARNING: Failed to load the specified logmodule " + logManagerModuleIdentifier);
                                    break block36;
                                }
                                Module.setModuleLogger(new JDKModuleLogger());
                            }
                            catch (Throwable throwable) {
                                void var14_23;
                                Main.setContextClassLoader((ClassLoader)var14_23);
                                throw throwable;
                            }
                        }
                        Main.setContextClassLoader(old);
                    }
                    System.err.println("WARNING: No log manager services defined in specified logmodule " + logManagerModuleIdentifier);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                System.err.println("WARNING: No log manager service descriptor found in specified logmodule " + logManagerModuleIdentifier);
            }
        }
        if (jaxpModuleIdentifier != null) {
            __JAXPRedirected.changeAll(jaxpModuleIdentifier, Module.getBootModuleLoader());
        }
        try {
            module = loader.loadModule(moduleIdentifier);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        try {
            ModuleLoader.installMBeanServer();
            module.run(moduleArgs);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static ClassLoader setContextClassLoader(final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Main.doSetContextClassLoader(classLoader);
                }
            });
        }
        return Main.doSetContextClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader doSetContextClassLoader(ClassLoader classLoader) {
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            return classLoader2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    static {
        long l = StartTimeHolder.START_TIME;
    }
}

