/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Set;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public abstract class DependencySpec {
    final PathFilter importFilter;
    final PathFilter exportFilter;

    DependencySpec(PathFilter importFilter, PathFilter exportFilter) {
        this.importFilter = importFilter;
        this.exportFilter = exportFilter;
    }

    abstract Dependency getDependency(Module var1);

    public static DependencySpec createLocalDependencySpec() {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll());
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        return new DependencySpec(importFilter, exportFilter){

            @Override
            Dependency getDependency(Module module) {
                ModuleClassLoader classLoader = module.getClassLoaderPrivate();
                return new LocalDependency(this.exportFilter, this.importFilter, classLoader.getLocalLoader(), classLoader.getPaths());
            }

            public String toString() {
                return "dependency on local resources";
            }
        };
    }

    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), PathFilters.rejectAll(), localLoader, loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths, boolean export) {
        return DependencySpec.createLocalDependencySpec(PathFilters.acceptAll(), export ? PathFilters.getDefaultImportFilter() : PathFilters.rejectAll(), localLoader, loaderPaths);
    }

    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, final LocalLoader localLoader, final Set<String> loaderPaths) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        if (localLoader == null) {
            throw new IllegalArgumentException("localLoader is null");
        }
        if (loaderPaths == null) {
            throw new IllegalArgumentException("loaderPaths is null");
        }
        return new DependencySpec(importFilter, exportFilter){

            @Override
            Dependency getDependency(Module module) {
                return new LocalDependency(this.exportFilter, this.importFilter, localLoader, loaderPaths);
            }

            public String toString() {
                return "dependency on local loader " + localLoader;
            }
        };
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier) {
        return DependencySpec.createModuleDependencySpec(identifier, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(identifier, export, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), null, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), moduleLoader, identifier, false);
    }

    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), export ? PathFilters.acceptAll() : PathFilters.rejectAll(), moduleLoader, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), exportFilter, null, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(PathFilters.getDefaultImportFilter(), exportFilter, moduleLoader, identifier, optional);
    }

    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, final ModuleLoader moduleLoader, final ModuleIdentifier identifier, final boolean optional) {
        if (importFilter == null) {
            throw new IllegalArgumentException("importFilter is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier is null");
        }
        return new DependencySpec(importFilter, exportFilter){

            @Override
            Dependency getDependency(Module module) {
                ModuleLoader loader = moduleLoader;
                return new ModuleDependency(this.exportFilter, this.importFilter, loader == null ? module.getModuleLoader() : loader, identifier, optional);
            }

            public String toString() {
                return "dependency on " + identifier;
            }
        };
    }
}

