/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.MultiplePathFilter;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;

public class MultiplePathFilterBuilder {
    private final List<PathFilter> filters = new ArrayList<PathFilter>();
    private final List<Boolean> includeFlags = new ArrayList<Boolean>();
    private final boolean defaultVal;

    MultiplePathFilterBuilder(boolean defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void addFilter(PathFilter filter, boolean include) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.filters.add(filter);
        this.includeFlags.add(include);
    }

    public PathFilter create() {
        PathFilter[] filters = this.filters.toArray(new PathFilter[this.filters.size()]);
        boolean[] includeFlags = new boolean[this.includeFlags.size()];
        int includeFlagsSize = this.includeFlags.size();
        for (int i = 0; i < includeFlagsSize; ++i) {
            includeFlags[i] = this.includeFlags.get(i);
        }
        if (filters.length == 0) {
            return this.defaultVal ? PathFilters.acceptAll() : PathFilters.rejectAll();
        }
        return new MultiplePathFilter(filters, includeFlags, this.defaultVal);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }
}

