/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.modules.LayeredModulePathFactory;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class LocalModuleFinder
implements ModuleFinder {
    private static final File[] NO_FILES = new File[0];
    private final File[] repoRoots;
    private final PathFilter pathFilter;

    private LocalModuleFinder(File[] repoRoots, PathFilter pathFilter, boolean cloneRoots) {
        this.repoRoots = cloneRoots && repoRoots.length > 0 ? (File[])repoRoots.clone() : repoRoots;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (File repoRoot : this.repoRoots) {
                if (repoRoot != null) continue;
                sm.checkPermission(new FilePermission(new File(repoRoot, "-").getPath(), "read"));
            }
        }
        this.pathFilter = pathFilter;
    }

    public LocalModuleFinder(File[] repoRoots, PathFilter pathFilter) {
        this(repoRoots, pathFilter, true);
    }

    public LocalModuleFinder(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleFinder() {
        this(true);
    }

    public LocalModuleFinder(boolean supportLayersAndAddOns) {
        this(supportLayersAndAddOns ? LayeredModulePathFactory.resolveLayeredModulePath(LocalModuleFinder.getModulePathFiles()) : LocalModuleFinder.getModulePathFiles(), PathFilters.acceptAll(), false);
    }

    private static File[] getModulePathFiles() {
        return LocalModuleFinder.getFiles(System.getProperty("module.path", System.getenv("JAVA_MODULEPATH")), 0, 0);
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        if (modulePath == null) {
            return NO_FILES;
        }
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = LocalModuleFinder.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    private static String toPathString(ModuleIdentifier moduleIdentifier) {
        StringBuilder builder = new StringBuilder(40);
        builder.append(moduleIdentifier.getName().replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(moduleIdentifier.getSlot());
        builder.append(File.separatorChar);
        return builder.toString();
    }

    @Override
    public ModuleSpec findModule(final ModuleIdentifier identifier, final ModuleLoader delegateLoader) throws ModuleLoadException {
        final String child = LocalModuleFinder.toPathString(identifier);
        if (this.pathFilter.accept(child)) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleSpec>(){

                    @Override
                    public ModuleSpec run() throws Exception {
                        for (File root : LocalModuleFinder.this.repoRoots) {
                            File file = new File(root, child);
                            File moduleXml = new File(file, "module.xml");
                            if (!moduleXml.exists()) continue;
                            ModuleSpec spec = ModuleXmlParser.parseModuleXml(delegateLoader, identifier, file, moduleXml);
                            if (spec == null) break;
                            return spec;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getException();
                }
                catch (RuntimeException e1) {
                    throw e1;
                }
                catch (ModuleLoadException e1) {
                    throw e1;
                }
                catch (Error e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw new UndeclaredThrowableException(e1);
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module finder @").append(Integer.toHexString(this.hashCode())).append(" (roots: ");
        int repoRootsLength = this.repoRoots.length;
        for (int i = 0; i < repoRootsLength; ++i) {
            File root = this.repoRoots[i];
            b.append(root);
            if (i == repoRootsLength - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }
}

