/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.modules.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * Utility class providing commonly used test utilities.
 *
 * @author John E. Bailey
 */
public class Util {

    public static byte[] readBytes(final InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buff = new byte[1024];
            int read;
            while((read = is.read(buff)) > -1) {
                os.write(buff, 0, read);
            }
        } finally {
            is.close();
        }
        return os.toByteArray();
    }

    public static URL getResource(final Class<?> baseClass, final String path) throws Exception {
        final URL url = baseClass.getClassLoader().getResource(path);
        return url;
    }

    public static File getResourceFile(final Class<?> baseClass, final String path) throws Exception {
        return new File(getResource(baseClass, path).toURI());
    }

    public static <T> List<T> toList(Enumeration<T> enumeration) {
        final List<T> list = new ArrayList<T>();
        while(enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static byte[] getClassBytes(final Class<?> aClass) throws Exception {
        final String resourcePath = getResourceNameOfClass(aClass);
        final File classFile = Util.getResourceFile(aClass, resourcePath);
        byte[] classBytes = Util.readBytes(new FileInputStream(classFile));
        return classBytes;
    }

    public static String getResourceNameOfClass(final Class<?> aClass) throws IllegalArgumentException {
        final String nameAsResourcePath = aClass.getName().replace('.', '/');
        final String resourceName = nameAsResourcePath + ".class";
        return resourceName;
    }

}
