/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.PlatformDiscoveryComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.adapter.impl.measurement.SimpleMetaValueMeasurementAdapter;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformComponent
implements ProfileServiceComponent<ProfileServiceComponent>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<ProfileServiceComponent> context;
    private String deployName;
    private String componentName;

    public void start(ResourceContext<ProfileServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
    }

    public void stop() {
    }

    @Override
    public ProfileServiceConnection getConnection() {
        ApplicationServerComponent component = (ApplicationServerComponent)this.context.getParentResourceComponent();
        return component.getConnection();
    }

    public EmsConnection getEmsConnection() {
        return ((ProfileServiceComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        return null;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        try {
            ManagedComponent component = this.loadComponent();
            for (MeasurementScheduleRequest request : requests) {
                SimpleMetaValueMeasurementAdapter measurementAdapter;
                ManagedProperty prop;
                String metricName = request.getName();
                String[] propertyName = this.parsePropertyName(metricName);
                if (propertyName.length == 0 || (prop = (ManagedProperty)component.getProperties().get(propertyName[0])) == null) continue;
                MetaType type = prop.getMetaType();
                MetaValue value = prop.getValue();
                if (value == null) continue;
                MeasurementDefinition measurementDefinition = ResourceTypeUtils.getMeasurementDefinition(this.context.getResourceType(), metricName);
                if (type.isSimple() && measurementDefinition != null & (measurementAdapter = new SimpleMetaValueMeasurementAdapter()) != null) {
                    measurementAdapter.setMeasurementData(report, value, request, measurementDefinition);
                }
                if (!type.isComposite()) continue;
                ManagedObject obj = prop.getManagedObject();
                Object attachment = obj.getAttachment();
                for (int i = 0; i < propertyName.length; ++i) {
                    attachment = this.getObjectProperty(attachment, propertyName[i]);
                }
                this.setMeasurementData(report, attachment, request, measurementDefinition);
            }
        }
        catch (NoSuchDeploymentException e) {
            this.log.error((Object)("Loaded component does not exist: " + (Object)((Object)e)));
        }
        catch (SecurityException e) {
            this.log.error((Object)("Security Exception: " + e));
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        return null;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }

    private ManagedComponent loadComponent() throws NoSuchDeploymentException {
        this.deployName = this.context.getPluginConfiguration().getSimple(PlatformDiscoveryComponent.PLATFORM_DEPLOYMENT_NAME).getStringValue();
        this.componentName = this.context.getPluginConfiguration().getSimple(PlatformDiscoveryComponent.PLATFORM_COMPONENT_NAME).getStringValue();
        ProfileServiceConnection connection = ((ProfileServiceComponent)this.context.getParentResourceComponent()).getConnection();
        ManagementView managementView = connection.getManagementView();
        ManagedDeployment deploy = managementView.getDeployment(this.deployName);
        if (deploy != null) {
            Map components = deploy.getComponents();
            return (ManagedComponent)components.get(this.componentName);
        }
        return null;
    }

    public AvailabilityType getAvailability() {
        return null;
    }

    public String[] parsePropertyName(String name) {
        if (name.indexOf(123) == -1) {
            String[] ps = new String[]{name};
            return ps;
        }
        name = name.substring(name.indexOf(123) + 1, name.indexOf(125));
        String[] ps = name.split("\\.");
        return ps;
    }

    protected Object getObjectProperty(Object value, String property) {
        try {
            PropertyDescriptor[] pds;
            for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(value.getClass()).getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                pd.getReadMethod().setAccessible(true);
                value = pd.getReadMethod().invoke(value, new Object[0]);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Object " + value.toString() + " does not contain property " + property), (Throwable)e);
        }
        return value;
    }

    public void setMeasurementData(MeasurementReport report, Object value, MeasurementScheduleRequest request, MeasurementDefinition measurementDefinition) {
        DataType dataType = measurementDefinition.getDataType();
        switch (dataType) {
            case MEASUREMENT: {
                try {
                    MeasurementDataNumeric dataNumeric = new MeasurementDataNumeric(request, new Double(value.toString()));
                    report.addData(dataNumeric);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Measurement request: " + request.getName() + " did not return a numeric value from the Profile Service"), (Throwable)e);
                }
                break;
            }
            case TRAIT: {
                MeasurementDataTrait dataTrait = new MeasurementDataTrait(request, String.valueOf(value));
                report.addData(dataTrait);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported measurement data type: " + dataType);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        ResourceType resourceType = this.context.getResourceType();
        OperationDefinition operationDefinition = ResourceTypeUtils.getOperationDefinition(resourceType, name);
        ManagedComponent component = this.loadComponent();
        Set operations = component.getOperations();
        for (ManagedOperation operation : operations) {
            if (!operation.getName().equals(name)) continue;
            MetaValue[] params = ConversionUtils.convertOperationsParametersToMetaValues(operation, parameters, operationDefinition);
            MetaValue operationResult = operation.invoke(params);
            OperationResult result = new OperationResult();
            ConversionUtils.convertManagedOperationResults(operation, operationResult, result.getComplexResults(), operationDefinition);
            return result;
        }
        return null;
    }
}

