/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedComponentComponent
extends AbstractManagedComponent
implements ConfigurationFacet,
DeleteResourceFacet,
OperationFacet,
MeasurementFacet {
    protected static final char PREFIX_DELIMITER = '|';
    private static final Map<String, Map<String, Boolean>> runtimeMetricMaps = new HashMap<String, Map<String, Boolean>>();
    private final Log log = LogFactory.getLog(this.getClass());
    private ManagedComponent managedComponent = null;
    private String componentName;
    private ComponentType componentType;

    public AvailabilityType getAvailability() {
        RunState runState = null;
        try {
            runState = this.getManagedComponent().getRunState();
        }
        catch (Throwable t) {
            this.log.debug((Object)"Could not get component state, cause: ", t);
            return AvailabilityType.DOWN;
        }
        if (runState == RunState.RUNNING) {
            return AvailabilityType.UP;
        }
        this.log.debug((Object)("Component was not running, state was: " + runState));
        return AvailabilityType.DOWN;
    }

    @Override
    public void start(ResourceContext<ProfileServiceComponent> resourceContext) throws Exception {
        super.start(resourceContext);
        this.componentType = ConversionUtils.getComponentType(this.getResourceContext().getResourceType());
        Configuration pluginConfig = resourceContext.getPluginConfiguration();
        this.componentName = pluginConfig.getSimple("componentName").getStringValue();
        this.log.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.componentType + " component '" + this.componentName + "'."));
    }

    @Override
    public void stop() {
        this.managedComponent = null;
        super.stop();
    }

    public Configuration loadResourceConfiguration() {
        Configuration resourceConfig;
        try {
            Map managedProperties = this.getManagedComponent().getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(this.getResourceContext().getPluginConfiguration());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("*** AFTER LOAD:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            resourceConfig = ConversionUtils.convertManagedObjectToConfiguration(managedProperties, customProps, this.getResourceContext().getResourceType());
        }
        catch (Exception e) {
            RunState runState = this.getManagedComponent().getRunState();
            if (runState == RunState.RUNNING) {
                this.log.error((Object)("Failed to load configuration for " + this.getResourceDescription() + "."), (Throwable)e);
            } else {
                this.log.debug((Object)("Failed to load configuration for " + this.getResourceDescription() + ", but managed component is not in the RUNNING state."), (Throwable)e);
            }
            throw new RuntimeException(ThrowableUtil.getAllMessages((Throwable)e));
        }
        return resourceConfig;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        Configuration resourceConfig = configurationUpdateReport.getConfiguration();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        try {
            ManagedComponent managedComponent = this.getManagedComponent();
            Map managedProperties = managedComponent.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(pluginConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("*** BEFORE UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, this.getResourceContext().getResourceType(), customProps);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("*** AFTER UPDATE:\n" + DebugUtils.convertPropertiesToString(managedProperties)));
            }
            this.updateComponent(managedComponent);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to update configuration for " + this.getResourceDescription() + "."), (Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
        }
    }

    public void deleteResource() throws Exception {
        DeploymentManager deploymentManager = this.getConnection().getDeploymentManager();
        if (!deploymentManager.isRedeploySupported()) {
            throw new UnsupportedOperationException("Deletion of " + this.getResourceContext().getResourceType().getName() + " Resources is not currently supported.");
        }
        ManagedComponent managedComponent = this.getManagedComponent();
        this.log.debug((Object)("Removing " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.removeComponent(managedComponent);
        ManagedDeployment parentDeployment = managedComponent.getDeployment();
        this.log.debug((Object)("Redeploying parent deployment '" + parentDeployment.getName() + "' in order to complete removal of component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        DeploymentProgress progress = deploymentManager.redeploy(parentDeployment.getName());
        DeploymentStatus redeployStatus = DeploymentUtils.run(progress);
        if (redeployStatus.isFailed()) {
            this.log.error((Object)("Failed to redeploy parent deployment '" + parentDeployment.getName() + "during removal of component " + ManagedComponentComponent.toString(managedComponent) + " - removal may not persist when the app server is restarted."), (Throwable)redeployStatus.getFailure());
        }
        managementView.load();
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        OperationDefinition operationDefinition = this.getOperationDefinition(name);
        ManagedOperation managedOperation = this.getManagedOperation(operationDefinition);
        MetaValue[] parameterMetaValues = ConversionUtils.convertOperationsParametersToMetaValues(managedOperation, parameters, operationDefinition);
        MetaValue resultMetaValue = managedOperation.invoke(parameterMetaValues);
        OperationResult result = new OperationResult();
        ConversionUtils.convertManagedOperationResults(managedOperation, resultMetaValue, result.getComplexResults(), operationDefinition);
        return result;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        Map<String, Boolean> runtimeMetricMap = runtimeMetricMaps.get(this.getClass().getName());
        if (null == runtimeMetricMap) {
            runtimeMetricMap = new HashMap<String, Boolean>();
            runtimeMetricMaps.put(this.getClass().getName(), runtimeMetricMap);
        }
        boolean forceRefresh = false;
        for (MeasurementScheduleRequest request : metrics) {
            Boolean isRuntimeMetric = runtimeMetricMap.get(request.getName());
            if (null == isRuntimeMetric) {
                ManagedProperty managedProp = this.getManagedProperty(this.managedComponent, request);
                runtimeMetricMap.put(request.getName(), null == managedProp || managedProp.hasViewUse(ViewUse.RUNTIME));
            }
            if (!Boolean.FALSE.equals(runtimeMetricMap.get(request.getName()))) continue;
            forceRefresh = true;
            break;
        }
        ManagedComponent managedComponent = this.getManagedComponent(forceRefresh);
        RunState runState = managedComponent.getRunState();
        for (MeasurementScheduleRequest request : metrics) {
            try {
                if (request.getName().equals("runState")) {
                    report.addData(new MeasurementDataTrait(request, runState.name()));
                    continue;
                }
                Object value = this.getSimpleValue(managedComponent, request);
                this.addValueToMeasurementReport(report, request, value);
            }
            catch (Exception e) {
                if (runState == RunState.RUNNING) {
                    this.log.error((Object)("Failed to collect metric for " + request), (Throwable)e);
                    continue;
                }
                this.log.debug((Object)("Failed to collect metric for " + request + ", but managed component is not in the RUNNING state."), (Throwable)e);
            }
        }
    }

    protected void updateComponent(ManagedComponent managedComponent) throws Exception {
        this.log.trace((Object)("Updating " + this.getResourceDescription() + " with component " + ManagedComponentComponent.toString(managedComponent) + "..."));
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.updateComponent(managedComponent);
        managementView.load();
    }

    @Nullable
    protected Object getSimpleValue(ManagedComponent managedComponent, MeasurementScheduleRequest request) {
        MetaValue metaValue;
        String metricName = request.getName();
        int pipeIndex = metricName.indexOf(124);
        String compositePropName = pipeIndex == -1 ? metricName : metricName.substring(pipeIndex + 1);
        int dotIndex = compositePropName.indexOf(46);
        String metricPropName = dotIndex == -1 ? compositePropName : compositePropName.substring(0, dotIndex);
        ManagedProperty metricProp = managedComponent.getProperty(metricPropName);
        if (metricProp == null) {
            return null;
        }
        if (dotIndex == -1) {
            metaValue = metricProp.getValue();
        } else {
            CompositeValue compositeValue = (CompositeValue)metricProp.getValue();
            String key = compositePropName.substring(dotIndex + 1);
            metaValue = compositeValue.get(key);
        }
        return ManagedComponentComponent.getInnerValue(metaValue);
    }

    @Nullable
    protected ManagedProperty getManagedProperty(ManagedComponent managedComponent, MeasurementScheduleRequest request) {
        String metricName = request.getName();
        int pipeIndex = metricName.indexOf(124);
        String compositePropName = pipeIndex == -1 ? metricName : metricName.substring(pipeIndex + 1);
        int dotIndex = compositePropName.indexOf(46);
        String metricPropName = dotIndex == -1 ? compositePropName : compositePropName.substring(0, dotIndex);
        ManagedProperty metricProp = managedComponent.getProperty(metricPropName);
        return metricProp;
    }

    @Nullable
    private static Object getInnerValue(MetaValue metaValue) {
        ArrayList<Object> value;
        if (metaValue == null) {
            return null;
        }
        if (metaValue.getMetaType().isSimple()) {
            SimpleValue simpleValue = (SimpleValue)metaValue;
            value = simpleValue.getValue();
        } else if (metaValue.getMetaType().isEnum()) {
            EnumValue enumValue = (EnumValue)metaValue;
            value = enumValue.getValue();
        } else if (metaValue.getMetaType().isArray()) {
            ArrayValue arrayValue = (ArrayValue)metaValue;
            value = arrayValue.getValue();
        } else if (metaValue.getMetaType().isCollection()) {
            CollectionValue collectionValue = (CollectionValue)metaValue;
            ArrayList<Object> list = new ArrayList<Object>();
            for (MetaValue element : collectionValue.getElements()) {
                list.add(ManagedComponentComponent.getInnerValue(element));
            }
            value = list;
        } else {
            value = metaValue.toString();
        }
        return value;
    }

    protected void addValueToMeasurementReport(MeasurementReport report, MeasurementScheduleRequest request, Object value) {
        if (value == null) {
            return;
        }
        String stringValue = ManagedComponentComponent.toString(value);
        DataType dataType = request.getDataType();
        switch (dataType) {
            case MEASUREMENT: {
                try {
                    MeasurementDataNumeric dataNumeric = new MeasurementDataNumeric(request, Double.valueOf(stringValue));
                    report.addData(dataNumeric);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("Profile service did not return a numeric value as expected for metric [" + request.getName() + "] - value returned was " + value + "."), (Throwable)e);
                }
                break;
            }
            case TRAIT: {
                MeasurementDataTrait dataTrait = new MeasurementDataTrait(request, stringValue);
                report.addData(dataTrait);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported measurement data type: " + dataType);
            }
        }
    }

    protected ComponentType getComponentType() {
        return this.componentType;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    protected ManagedComponent getManagedComponent() {
        return this.getManagedComponent(false);
    }

    protected ManagedComponent getManagedComponent(boolean forceRefresh) {
        if (!forceRefresh && null != this.managedComponent) {
            return this.managedComponent;
        }
        try {
            ManagementView managementView = this.getConnection().getManagementView();
            this.managedComponent = managementView.getComponent(this.componentName, this.componentType);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load [" + this.componentType + "] ManagedComponent [" + this.componentName + "].", e);
        }
        if (this.managedComponent == null) {
            throw new IllegalStateException("Failed to find [" + this.componentType + "] ManagedComponent named [" + this.componentName + "].");
        }
        this.log.trace((Object)("Retrieved " + ManagedComponentComponent.toString(this.managedComponent) + "."));
        return this.managedComponent;
    }

    @NotNull
    private OperationDefinition getOperationDefinition(String operationName) {
        ResourceType resourceType = this.getResourceContext().getResourceType();
        OperationDefinition operationDefinition = ResourceTypeUtils.getOperationDefinition(resourceType, operationName);
        if (operationDefinition == null) {
            throw new IllegalStateException("Operation named '" + operationName + "' is not defined for Resource type '" + resourceType.getName() + "' in the '" + resourceType.getPlugin() + "' plugin's descriptor.");
        }
        return operationDefinition;
    }

    @NotNull
    private ManagedOperation getManagedOperation(OperationDefinition operationDefinition) {
        ManagedComponent managedComponent = this.getManagedComponent();
        Set operations = managedComponent.getOperations();
        for (ManagedOperation operation : operations) {
            int paramCount;
            ConfigurationDefinition paramsConfigDef = operationDefinition.getParametersConfigurationDefinition();
            int n = paramCount = paramsConfigDef != null ? paramsConfigDef.getPropertyDefinitions().size() : 0;
            if (!operation.getName().equals(operationDefinition.getName()) || operation.getParameters().length != paramCount) continue;
            return operation;
        }
        throw new IllegalStateException("ManagedOperation named '" + operationDefinition.getName() + "' not found on ManagedComponent [" + this.getManagedComponent() + "].");
    }

    private static String toString(ManagedComponent managedComponent) {
        Map properties = managedComponent.getProperties();
        return managedComponent.getClass().getSimpleName() + "@" + System.identityHashCode(managedComponent) + "[" + "type=" + managedComponent.getType() + ", name=" + managedComponent.getName() + ", properties=" + properties.getClass().getSimpleName() + "@" + System.identityHashCode(properties) + "]";
    }

    private static String toString(@NotNull Object value) {
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int lastIndex = Array.getLength(value) - 1;
            for (int i = 0; i < Array.getLength(value); ++i) {
                buffer.append(String.valueOf(Array.get(value, i)));
                if (i == lastIndex) break;
                buffer.append(", ");
            }
            return buffer.toString();
        }
        return value.toString();
    }

    public static interface Config {
        public static final String COMPONENT_TYPE = "componentType";
        public static final String COMPONENT_SUBTYPE = "componentSubtype";
        public static final String COMPONENT_NAME = "componentName";
        public static final String TEMPLATE_NAME = "templateName";
        public static final String COMPONENT_NAME_PROPERTY = "componentNameProperty";
    }
}

