/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.deploy;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.util.file.FileUtil;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.deploy.PackageDownloader;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDownloader
implements PackageDownloader {
    private ResourceContext<?> resourceContext;
    private boolean resourceExists;
    private ProfileServiceConnection profileServiceConnection;
    private static final Log LOG = LogFactory.getLog(RemoteDownloader.class);

    public RemoteDownloader(ResourceContext<?> resourceContext, boolean resourceExists, ProfileServiceConnection profileServiceConnection) {
        this.resourceContext = resourceContext;
        this.resourceExists = resourceExists;
        this.profileServiceConnection = profileServiceConnection;
    }

    @Override
    public File prepareArchive(PackageDetailsKey key, ResourceType resourceType) {
        OutputStream os = null;
        try {
            File tempDir = FileUtil.createTempDirectory((String)"jopr-jbossas5-deploy-content", null, (File)RemoteDownloader.getServerTempDirectory(this.profileServiceConnection));
            File archiveFile = new File(key.getName());
            File contentCopy = new File(tempDir, archiveFile.getName());
            os = new BufferedOutputStream(new FileOutputStream(contentCopy));
            ContentContext contentContext = this.resourceContext.getContentContext();
            ContentServices contentServices = contentContext.getContentServices();
            if (this.resourceExists) {
                contentServices.downloadPackageBits(contentContext, key, os, true);
            } else {
                contentServices.downloadPackageBitsForChildResource(contentContext, resourceType.getName(), key, os);
            }
            File file = contentCopy;
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy the deployed archive to destination.", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Failed to close the stream when copying deployment to destination.");
                }
            }
        }
    }

    @Override
    public void destroyArchive(File archive) {
        File tempDir = archive.getParentFile();
        archive.delete();
        tempDir.delete();
    }

    private static File getServerTempDirectory(ProfileServiceConnection profileServiceConnection) {
        ManagementView managementView = profileServiceConnection.getManagementView();
        ManagedComponent serverConfigComponent = ManagedComponentUtils.getSingletonManagedComponent(managementView, new ComponentType("MCBean", "ServerConfig"));
        String serverTempDir = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "serverTempDir"));
        return new File(serverTempDir);
    }
}

