/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.deploy;

import java.io.File;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.file.FileUtil;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.deploy.PackageDownloader;
import org.rhq.plugins.jbossas5.script.ScriptFileFinder;

public class ScriptDeployer
implements Deployer {
    private static final String PROP_TARGET_FILE_NAME = "targetFileName";
    private PackageDownloader downloader;
    private File binDir;
    private SystemInfo systemInfo;

    public ScriptDeployer(String jbossHomeDir, SystemInfo systemInfo, PackageDownloader downloader) {
        this.downloader = downloader;
        this.binDir = new File(jbossHomeDir, "bin");
        this.systemInfo = systemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(CreateResourceReport createResourceReport, ResourceType resourceType) {
        File target;
        String targetFileName;
        File script;
        block13: {
            block12: {
                script = null;
                ResourcePackageDetails details = createResourceReport.getPackageDetails();
                script = this.downloader.prepareArchive(details.getKey(), resourceType);
                targetFileName = script.getName();
                Configuration deploymentConfig = details.getDeploymentTimeConfiguration();
                if (deploymentConfig != null) {
                    targetFileName = deploymentConfig.getSimpleValue(PROP_TARGET_FILE_NAME, targetFileName);
                }
                target = new File(this.binDir, targetFileName);
                if (ScriptFileFinder.getScriptFileFilter(this.systemInfo).accept(target)) break block12;
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setErrorMessage("The supplied filename has a wrong extension. One of: " + ScriptFileFinder.getSupportedFileExtensions(this.systemInfo) + " was expected.");
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
                return;
            }
            if (target.createNewFile()) break block13;
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("A file called '" + targetFileName + "' already exists in the server bin directory.");
            if (script != null) {
                this.downloader.destroyArchive(script);
            }
            return;
        }
        try {
            FileUtil.copyFile((File)script, (File)target);
            createResourceReport.setResourceKey(target.getAbsolutePath());
            createResourceReport.setResourceName(targetFileName);
            createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            if (script != null) {
                this.downloader.destroyArchive(script);
            }
        }
        catch (Exception e) {
            try {
                createResourceReport.setException((Throwable)e);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
            }
            catch (Throwable throwable) {
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployIndividualPackageResponse update(ResourcePackageDetails existingPackage, ResourceType resourceType) {
        File target;
        DeployIndividualPackageResponse response;
        File script;
        block13: {
            String targetFileName;
            block12: {
                script = null;
                response = new DeployIndividualPackageResponse(existingPackage.getKey());
                ResourcePackageDetails details = existingPackage;
                script = this.downloader.prepareArchive(details.getKey(), resourceType);
                targetFileName = script.getName();
                Configuration deploymentConfig = details.getDeploymentTimeConfiguration();
                if (deploymentConfig != null) {
                    targetFileName = deploymentConfig.getSimpleValue(PROP_TARGET_FILE_NAME, targetFileName);
                }
                target = new File(this.binDir, targetFileName);
                if (ScriptFileFinder.getScriptFileFilter(this.systemInfo).accept(target)) break block12;
                response.setResult(ContentResponseResult.FAILURE);
                response.setErrorMessage("The supplied filename has a wrong extension. One of: " + ScriptFileFinder.getSupportedFileExtensions(this.systemInfo) + " was expected.");
                DeployIndividualPackageResponse deployIndividualPackageResponse = response;
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
                return deployIndividualPackageResponse;
            }
            if (target.exists()) break block13;
            response.setResult(ContentResponseResult.FAILURE);
            response.setErrorMessage("A file called '" + targetFileName + "' already exists in the server bin directory.");
            DeployIndividualPackageResponse deployIndividualPackageResponse = response;
            if (script != null) {
                this.downloader.destroyArchive(script);
            }
            return deployIndividualPackageResponse;
        }
        try {
            FileUtil.copyFile((File)script, (File)target);
            response.setResult(ContentResponseResult.SUCCESS);
            DeployIndividualPackageResponse deployIndividualPackageResponse = response;
            if (script != null) {
                this.downloader.destroyArchive(script);
            }
            return deployIndividualPackageResponse;
        }
        catch (Exception e) {
            try {
                response.setErrorMessage(e.getMessage());
                response.setResult(ContentResponseResult.FAILURE);
                DeployIndividualPackageResponse deployIndividualPackageResponse = response;
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
                return deployIndividualPackageResponse;
            }
            catch (Throwable throwable) {
                if (script != null) {
                    this.downloader.destroyArchive(script);
                }
                throw throwable;
            }
        }
    }
}

