/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.script;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFileFinder {
    private final Log log = LogFactory.getLog(this.getClass());
    private SystemInfo systemInfo;
    private List<File> scanDirectories;

    public static List<String> getSupportedFileExtensions(SystemInfo systemInfo) {
        switch (systemInfo.getOperatingSystemType()) {
            case WINDOWS: {
                return Arrays.asList("bat", "cmd");
            }
        }
        return Arrays.asList("sh", "pl");
    }

    public static FileFilter getScriptFileFilter(SystemInfo systemInfo) {
        final List<String> supportedExtensions = ScriptFileFinder.getSupportedFileExtensions(systemInfo);
        final boolean isCaseSensitive = systemInfo.getOperatingSystemType() != OperatingSystemType.WINDOWS;
        return new FileFilter(){

            public boolean accept(File file) {
                String extension;
                if (file.isDirectory()) {
                    return false;
                }
                String path = file.getPath();
                int dotIndex = path.lastIndexOf(".");
                String string = extension = dotIndex != -1 ? path.substring(dotIndex + 1) : "";
                if (isCaseSensitive) {
                    return supportedExtensions.contains(extension);
                }
                for (String supportedExtension : supportedExtensions) {
                    if (!supportedExtension.equalsIgnoreCase(extension)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public ScriptFileFinder(SystemInfo systemInfo, File ... scanDirectories) {
        this.scanDirectories = Arrays.asList(scanDirectories);
        this.systemInfo = systemInfo;
    }

    protected List<File> getScanDirectories() {
        return this.scanDirectories;
    }

    @NotNull
    public List<File> findScriptFiles() {
        ArrayList<File> scriptFiles = new ArrayList<File>();
        for (File scanDir : this.scanDirectories) {
            if (!scanDir.isAbsolute()) {
                this.log.warn((Object)("The specified scan directory (" + scanDir + ") is not absolute."));
                continue;
            }
            if (!scanDir.exists()) {
                this.log.warn((Object)("The specified scan directory (" + scanDir + ") does not exist."));
                continue;
            }
            if (!scanDir.isDirectory()) {
                this.log.warn((Object)("The specified scan directory (" + scanDir + ") is not a directory."));
                continue;
            }
            this.findScriptFiles(scanDir, new ArrayList<File>(), scriptFiles);
        }
        return scriptFiles;
    }

    protected void findScriptFiles(File scanDir, List<File> excludeDirs, List<File> scriptFiles) {
        File[] subDirs;
        if (!scanDir.isDirectory()) {
            return;
        }
        File canonicalScanDir = null;
        try {
            canonicalScanDir = scanDir.getCanonicalFile();
        }
        catch (IOException e) {
            return;
        }
        if (excludeDirs.contains(canonicalScanDir)) {
            return;
        }
        excludeDirs.add(canonicalScanDir);
        scriptFiles.addAll(Arrays.asList(scanDir.listFiles(ScriptFileFinder.getScriptFileFilter(this.systemInfo))));
        for (File subDir : subDirs = scanDir.listFiles(new DirectoryFilter())) {
            this.findScriptFiles(subDir, excludeDirs, scriptFiles);
        }
    }

    protected static class DirectoryFilter
    implements FileFilter {
        protected DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

