/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.serviceBinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    public static final String STANDARD_BINDINGS_PROPERTY = "standardBindings";
    public static final String OVERRIDE_BINDINGS_PROPERTY = "overrideBindings";
    public static final String ACTIVE_BINDING_SET_NAME_PROPERTY = "activeBindingSetName";
    public static final String BINDING_SETS_PROPERTY = "bindingSets";
    public static final String NAME_PROPERTY = "name";
    public static final String DEFAULT_HOST_NAME_PROPERTY = "defaultHostName";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String FULLY_QUALIFIED_NAME_PROPERTY = "fullyQualifiedName";
    public static final String BINDING_NAME_PROPERTY = "bindingName";
    public static final String SERVICE_NAME_PROPERTY = "serviceName";
    public static final String PORT_OFFSET_PROPERTY = "portOffset";
    public static final String HOST_NAME_PROPERTY = "hostName";
    public static final String PORT_PROPERTY = "port";
    public static final String FIXED_HOST_NAME_PROPERTY = "fixedHostName";
    public static final String FIXED_PORT_PROPERTY = "fixedPort";
    public static final PropertyDefinition[] BINDING_SET_SIMPLE_PROPERTIES = new PropertyDefinition[]{new PropertyDefinition("name", String.class), new PropertyDefinition("defaultHostName", String.class), new PropertyDefinition("portOffset", Integer.class)};
    public static final PropertyDefinition[] BINDING_SET_OVERRIDE_PROPERTIES = new PropertyDefinition[]{new PropertyDefinition("serviceName", String.class), new PropertyDefinition("bindingName", String.class), new PropertyDefinition("fullyQualifiedName", String.class), new PropertyDefinition("description", String.class), new PropertyDefinition("hostName", String.class), new PropertyDefinition("port", Integer.class)};
    public static final PropertyDefinition[] STANDARD_BINDING_PROPERTIES = new PropertyDefinition[]{new PropertyDefinition("serviceName", String.class), new PropertyDefinition("bindingName", String.class), new PropertyDefinition("port", Integer.class), new PropertyDefinition("hostName", String.class), new PropertyDefinition("description", String.class), new PropertyDefinition("fullyQualifiedName", String.class), new PropertyDefinition("fixedHostName", Boolean.class), new PropertyDefinition("fixedPort", Boolean.class)};

    private Util() {
    }

    public static <T> T getValue(SimpleValue value, Class<T> type) {
        if (value == null) {
            return null;
        }
        return type.cast(value.getValue());
    }

    public static <T> T getValue(CompositeValue compositeValue, String simpleValueName, Class<T> type) {
        SimpleValue val = (SimpleValue)compositeValue.get(simpleValueName);
        return Util.getValue(val, type);
    }

    public static CompositeValue getBindingSetFromConfiguration(MetaType bindingSetValueType, Configuration configuration) throws Exception {
        MapCompositeValueSupport currentBindingSet = new MapCompositeValueSupport(bindingSetValueType);
        for (PropertyDefinition def : Arrays.asList(BINDING_SET_SIMPLE_PROPERTIES)) {
            currentBindingSet.put(def.propertyName, (MetaValue)Util.wrap(configuration.getSimple(def.propertyName), def.propertyType));
        }
        CollectionMetaType overrideBindingsMetaType = (CollectionMetaType)((ImmutableCompositeMetaType)bindingSetValueType).getType(OVERRIDE_BINDINGS_PROPERTY);
        ArrayList<MapCompositeValueSupport> updatedOverrideBindings = new ArrayList<MapCompositeValueSupport>();
        for (Property prop : configuration.getList(OVERRIDE_BINDINGS_PROPERTY).getList()) {
            PropertyMap updatedBinding = (PropertyMap)prop;
            MapCompositeValueSupport newBinding = new MapCompositeValueSupport((MetaType)((CompositeMetaType)overrideBindingsMetaType.getElementType()));
            for (PropertyDefinition def : Arrays.asList(BINDING_SET_OVERRIDE_PROPERTIES)) {
                newBinding.put(def.propertyName, (MetaValue)Util.wrap(updatedBinding.getSimple(def.propertyName), def.propertyType));
            }
            updatedOverrideBindings.add(newBinding);
        }
        CollectionValueSupport newOverrideBindings = new CollectionValueSupport(overrideBindingsMetaType);
        newOverrideBindings.setElements(updatedOverrideBindings.toArray(new MetaValue[updatedOverrideBindings.size()]));
        currentBindingSet.put(OVERRIDE_BINDINGS_PROPERTY, (MetaValue)newOverrideBindings);
        return currentBindingSet;
    }

    public static List<MetaValue> replaceWithNew(CollectionValue collection, String replacedName, MetaValue newValue) {
        ArrayList<MetaValue> ret = new ArrayList<MetaValue>();
        for (CompositeValue value : collection) {
            String currentName = Util.getValue(value, NAME_PROPERTY, String.class);
            if (replacedName.equals(currentName)) {
                if (newValue == null) continue;
                ret.add(newValue);
                continue;
            }
            ret.add((MetaValue)value);
        }
        return ret;
    }

    public static SimpleValue wrap(PropertySimple value, Class<?> type) {
        Object ret = null;
        if (value == null) {
            ret = null;
        } else if (value.getStringValue() == null) {
            ret = null;
        } else if (type == Integer.class) {
            ret = value.getIntegerValue();
        } else if (type == Long.class) {
            ret = value.getLongValue();
        } else if (type == Double.class) {
            ret = value.getDoubleValue();
        } else if (type == Boolean.class) {
            ret = value.getBooleanValue();
        } else if (type == Float.class) {
            ret = value.getFloatValue();
        } else if (type == String.class) {
            ret = value.getStringValue();
        }
        return ret == null ? null : SimpleValueSupport.wrap(ret);
    }

    public static List<PropertySimple> getProperties(List<PropertyDefinition> properties, CompositeValue value) {
        ArrayList<PropertySimple> ret = new ArrayList<PropertySimple>();
        for (PropertyDefinition def : properties) {
            ret.add(new PropertySimple(def.propertyName, Util.getValue(value, def.propertyName, def.propertyType)));
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyDefinition {
        public String propertyName;
        public Class<?> propertyType;

        public PropertyDefinition(String propertyName, Class<?> propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }
    }
}

