/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.metatype.api.values.SimpleValue;

public class Ejb2BeanUtils {
    private static final ComponentType MDB_COMPONENT_TYPE = new ComponentType("EJB", "MDB");

    private Ejb2BeanUtils() {
    }

    public static String getUniqueBeanIdentificator(ManagedComponent component) {
        if (MDB_COMPONENT_TYPE.equals((Object)component.getType())) {
            String componentName = Ejb2BeanUtils.stripObjectId(component.getName());
            String deploymentName = ((SimpleValue)component.getProperty("DeploymentName").getValue()).getValue().toString();
            return deploymentName + "|" + componentName;
        }
        return component.getName();
    }

    public static String parseResourceName(ManagedComponent component) {
        String resourceName = Ejb2BeanUtils.parseSimpleResourceName(component.getName());
        if (MDB_COMPONENT_TYPE.equals((Object)component.getType())) {
            resourceName = Ejb2BeanUtils.stripObjectId(resourceName);
        }
        return resourceName;
    }

    private static String parseSimpleResourceName(String componentName) {
        int jndiNameIdx = componentName.indexOf("jndiName=");
        int commaIdx = componentName.indexOf(44, jndiNameIdx += 9);
        if (commaIdx == -1) {
            commaIdx = componentName.length();
        }
        int slashIdx = componentName.lastIndexOf(47, commaIdx);
        int startIdx = ++slashIdx > jndiNameIdx ? slashIdx : jndiNameIdx;
        return componentName.substring(startIdx, commaIdx);
    }

    private static String stripObjectId(String resourceName) {
        int atIdx = resourceName.indexOf(64);
        if (atIdx != -1) {
            resourceName = resourceName.substring(0, atIdx);
        }
        return resourceName;
    }
}

