/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.impl.configuration.custom;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.plugins.jbossas5.adapter.api.AbstractPropertyListAdapter;

public class ConnectionFactoryConfigPropertyAdapter
extends AbstractPropertyListAdapter {
    @Override
    public MetaValue convertToMetaValue(PropertyList property, PropertyDefinitionList propertyDefinition, MetaType metaType) {
        MapCompositeValueSupport valuesMap = new MapCompositeValueSupport(metaType);
        this.populateMetaValueFromProperty(property, (MetaValue)valuesMap, propertyDefinition);
        return valuesMap;
    }

    @Override
    public void populateMetaValueFromProperty(PropertyList property, MetaValue metaValue, PropertyDefinitionList propertyDefinition) {
        MapCompositeValueSupport valuesMap = (MapCompositeValueSupport)metaValue;
        for (Property p : property.getList()) {
            PropertyMap propertyMap = (PropertyMap)p;
            PropertySimple nameProperty = (PropertySimple)propertyMap.get("name");
            PropertySimple typeProperty = (PropertySimple)propertyMap.get("type");
            PropertySimple valueProperty = (PropertySimple)propertyMap.get("value");
            String configPropertyName = nameProperty.getStringValue();
            String configPropertyType = typeProperty.getStringValue();
            String configPropertyValue = valueProperty.getStringValue();
            if (!ConfigPropertyType.fromTypeName(configPropertyType).isValueValid(configPropertyValue)) {
                String message = "The value of Config Property '" + configPropertyName + "' has an invalid value for its type.";
                property.setErrorMessage(message);
                throw new IllegalArgumentException(message);
            }
            valuesMap.put(configPropertyName, (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)valueProperty.getStringValue())));
            valuesMap.put(configPropertyName + ".type", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)typeProperty.getStringValue())));
        }
    }

    @Override
    public void populatePropertyFromMetaValue(PropertyList property, MetaValue metaValue, PropertyDefinitionList propertyDefinition) {
        MapCompositeValueSupport valuesMap = (MapCompositeValueSupport)metaValue;
        for (ConfigProperty configProperty : this.getConfigProperties(valuesMap)) {
            PropertySimple name = new PropertySimple("name", (Object)configProperty.getName());
            PropertySimple type = new PropertySimple("type", (Object)configProperty.getType().getTypeName());
            PropertySimple value = new PropertySimple("value", (Object)configProperty.getValue());
            property.add((Property)new PropertyMap("config-property", new Property[]{name, type, value}));
        }
    }

    private Collection<ConfigProperty> getConfigProperties(MapCompositeValueSupport valuesMap) {
        LinkedHashMap<String, ConfigProperty> results = new LinkedHashMap<String, ConfigProperty>();
        for (String key : valuesMap.getMetaType().keySet()) {
            String propertyName;
            ConfigPropertyType propertyType = null;
            Serializable propertyValue = null;
            if (key.endsWith(".type")) {
                propertyName = key.substring(0, key.length() - 5);
                SimpleValue typeName = (SimpleValue)valuesMap.get(key);
                propertyType = ConfigPropertyType.fromTypeName(typeName.getValue().toString());
            } else {
                propertyName = key;
                SimpleValue value = (SimpleValue)valuesMap.get(key);
                if (value != null) {
                    propertyValue = value.getValue();
                }
            }
            ConfigProperty property = (ConfigProperty)results.get(propertyName);
            if (property == null) {
                property = new ConfigProperty();
                property.setName(propertyName);
                results.put(propertyName, property);
            }
            if (propertyType != null) {
                property.setType(propertyType);
            }
            if (propertyValue == null) continue;
            property.setValue(propertyValue);
        }
        return results.values();
    }

    private static class ConfigProperty {
        private String name;
        private ConfigPropertyType type;
        private Serializable value;

        private ConfigProperty() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ConfigPropertyType getType() {
            return this.type;
        }

        public void setType(ConfigPropertyType type) {
            this.type = type;
        }

        public Serializable getValue() {
            return this.value;
        }

        public void setValue(Serializable value) {
            this.value = value;
        }

        public String toString() {
            return "ConfigProperty[" + this.name + "(" + (Object)((Object)this.type) + ") : " + this.value + "]";
        }

        public SimpleValue getTypeDefinitionValue() {
            return new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.type.getTypeName()));
        }

        public SimpleValue getValueDefinitionValue() {
            return new SimpleValueSupport(this.type.getMetaType(), this.value);
        }
    }

    private static enum ConfigPropertyType {
        STRING(SimpleMetaType.STRING){

            @Override
            public boolean isValueValid(String value) {
                return true;
            }
        }
        ,
        CHARACTER(SimpleMetaType.CHARACTER){

            @Override
            public boolean isValueValid(String value) {
                return value == null || value.length() == 1;
            }
        }
        ,
        BOOLEAN(SimpleMetaType.BOOLEAN){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
            }
        }
        ,
        BYTE(SimpleMetaType.BYTE){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Byte.parseByte(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        SHORT(SimpleMetaType.SHORT){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Short.parseShort(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        INTEGER(SimpleMetaType.INTEGER){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Integer.parseInt(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        LONG(SimpleMetaType.LONG){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Long.parseLong(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        FLOAT(SimpleMetaType.FLOAT){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Float.parseFloat(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        DOUBLE(SimpleMetaType.DOUBLE){

            @Override
            public boolean isValueValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Double.parseDouble(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        ,
        INVALID(SimpleMetaType.VOID){

            @Override
            public boolean isValueValid(String value) {
                return false;
            }
        };

        private SimpleMetaType metaType;

        private ConfigPropertyType(SimpleMetaType metaType) {
            this.metaType = metaType;
        }

        public static ConfigPropertyType fromTypeName(String typeName) {
            for (ConfigPropertyType type : ConfigPropertyType.values()) {
                if (!type.getTypeName().equals(typeName)) continue;
                return type;
            }
            return INVALID;
        }

        public String getTypeName() {
            return this.metaType.getClassName();
        }

        public SimpleMetaType getMetaType() {
            return this.metaType;
        }

        public abstract boolean isValueValid(String var1);

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

