/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.net.URI;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.ProgressEvent;
import org.jboss.deployers.spi.management.deploy.ProgressListener;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.AbstractManagedComponent;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentDiscoveryComponent;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.WarMeasurementFacetDelegate;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

public abstract class AbstractManagedDeploymentComponent
extends AbstractManagedComponent
implements MeasurementFacet,
OperationFacet,
ProgressListener {
    private static final Log LOG = LogFactory.getLog(AbstractManagedDeploymentComponent.class);
    @Deprecated
    public static final String DEPLOYMENT_NAME_PROPERTY = "deploymentName";
    public static final String DEPLOYMENT_KEY_PROPERTY = "deploymentKey";
    public static final String DEPLOYMENT_TYPE_NAME_PROPERTY = "deploymentTypeName";
    public static final String EXTENSION_PROPERTY = "extension";
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    @Deprecated
    protected volatile String deploymentName;
    protected KnownDeploymentTypes deploymentType;
    protected File deploymentFile;
    private String deploymentKey;

    @Override
    public void start(ResourceContext<ProfileServiceComponent<?>> resourceContext) throws Exception {
        block3: {
            super.start(resourceContext);
            Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
            this.deploymentKey = pluginConfig.getSimpleValue(DEPLOYMENT_KEY_PROPERTY);
            this.deploymentFile = this.getDeploymentFile(this.deploymentKey);
            this.deploymentName = this.lookupDeploymentName();
            String deploymentTypeName = pluginConfig.getSimple(DEPLOYMENT_TYPE_NAME_PROPERTY).getStringValue();
            this.deploymentType = KnownDeploymentTypes.valueOf((String)deploymentTypeName);
            try {
                this.getManagedDeployment();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.warn((Object)("Could not start deployment for [" + this.deploymentKey + "] no longer exists. It may have been deleted from the filesystem external to RHQ."));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Started ResourceComponent for " + this.getResourceDescription() + ", managing " + this.deploymentType + " deployment '" + this.deploymentKey + "' with path '" + this.deploymentFile + "'."));
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.deploymentName = null;
        this.deploymentType = null;
        this.deploymentFile = null;
        this.deploymentKey = null;
    }

    private synchronized String lookupDeploymentName() {
        ManagementView managementView = AbstractManagedDeploymentDiscoveryComponent.getManagementView(this.getConnection());
        if (managementView == null) {
            return null;
        }
        Set<String> deploymentNames = AbstractManagedDeploymentDiscoveryComponent.getDeploymentNamesForType(managementView, this.getResourceContext().getResourceType());
        for (String deploymentName : deploymentNames) {
            if (!this.deploymentKey.equals(URI.create(deploymentName).getPath())) continue;
            return deploymentName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Did not find deployment with key [" + this.deploymentKey + "]"));
        }
        return null;
    }

    public AvailabilityType getAvailability() {
        DeploymentState deploymentState;
        try {
            deploymentState = this.getManagedDeployment(false).getDeploymentState();
        }
        catch (NoSuchDeploymentException e) {
            LOG.warn((Object)(this.deploymentType + " deployment '" + this.deploymentKey + "' not found. Cause: " + e.getLocalizedMessage()));
            this.deploymentName = null;
            return AvailabilityType.DOWN;
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Could not get deployment state for " + this.deploymentType + " deployment '" + this.deploymentKey + "', cause: "), t);
            }
            this.deploymentName = null;
            return AvailabilityType.DOWN;
        }
        if (deploymentState == DeploymentState.STARTED) {
            return AvailabilityType.UP;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.deploymentType + " deployment '" + this.deploymentKey + "' was not running, state was: " + deploymentState));
        }
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        if (this.deploymentType == KnownDeploymentTypes.JavaEEWebApplication) {
            WarMeasurementFacetDelegate warMeasurementFacetDelegate = new WarMeasurementFacetDelegate(this);
            warMeasurementFacetDelegate.getValues(report, requests);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        DeploymentProgress progress;
        ProfileServiceConnection connection = this.getConnection();
        if (connection == null) {
            OperationResult result = new OperationResult();
            result.setErrorMessage("No profile service connection available");
            return result;
        }
        String deploymentName = this.getDeploymentName();
        if (deploymentName == null) {
            OperationResult result = new OperationResult();
            result.setErrorMessage("Did not find deployment with key [" + this.deploymentKey + "]");
            return result;
        }
        DeploymentManager deploymentManager = connection.getDeploymentManager();
        if (name.equals("start")) {
            if (this.getAvailability() == AvailabilityType.UP) {
                LOG.warn((Object)("Operation '" + name + "' on " + this.getResourceDescription() + " failed because the Resource is already started."));
                OperationResult result = new OperationResult();
                result.setErrorMessage(this.deploymentFile.getName() + " is already started.");
                return result;
            }
            progress = deploymentManager.start(new String[]{deploymentName});
        } else if (name.equals("stop")) {
            progress = deploymentManager.stop(new String[]{deploymentName});
        } else {
            if (!name.equals("restart")) {
                throw new UnsupportedOperationException(name);
            }
            progress = deploymentManager.stop(new String[]{deploymentName});
            DeploymentUtils.run(progress);
            progress = deploymentManager.start(new String[]{deploymentName});
        }
        DeploymentStatus status = DeploymentUtils.run(progress);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Operation '" + name + "' on " + this.getResourceDescription() + " returned status [" + status + "]."));
        }
        if (status.isFailed()) {
            throw status.getFailure();
        }
        return new OperationResult();
    }

    public void progressEvent(ProgressEvent event) {
        LOG.debug((Object)event);
    }

    public String getDeploymentName() {
        if (this.deploymentName == null) {
            this.deploymentName = this.lookupDeploymentName();
        }
        return this.deploymentName;
    }

    public KnownDeploymentTypes getDeploymentType() {
        return this.deploymentType;
    }

    public final String getDeploymentKey() {
        return this.deploymentKey;
    }

    protected ManagedDeployment getManagedDeployment() throws NoSuchDeploymentException {
        return this.getManagedDeployment(true);
    }

    protected ManagedDeployment getManagedDeployment(boolean forceLoad) throws NoSuchDeploymentException {
        String deploymentName;
        ManagementView managementView = this.getConnection().getManagementView();
        if (forceLoad) {
            managementView.load();
        }
        if ((deploymentName = this.getDeploymentName()) == null) {
            throw new NoSuchDeploymentException("Did not find deployment with key [" + this.deploymentKey + "]");
        }
        return managementView.getDeployment(deploymentName);
    }

    private File getDeploymentFile(String deploymentKey) {
        if (IS_WINDOWS && deploymentKey.charAt(0) == '/') {
            deploymentKey = deploymentKey.substring(1);
        }
        return new File(deploymentKey);
    }
}

