/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.deploy;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileKey;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.FileContentDelegate;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.deploy.PackageDownloader;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DeploymentUtils;

public class ManagedComponentDeployer
implements Deployer {
    private static final Log LOG = LogFactory.getLog(ManagedComponentDeployer.class);
    private static final ProfileKey FARM_PROFILE_KEY = new ProfileKey("farm");
    private static final ProfileKey APPLICATIONS_PROFILE_KEY = new ProfileKey("applications");
    private PackageDownloader downloader;
    private ProfileServiceConnection profileServiceConnection;
    private ResourceContext<?> parentResourceContext;

    @Deprecated
    public ManagedComponentDeployer(ProfileServiceConnection profileServiceConnection, PackageDownloader downloader) {
        this(profileServiceConnection, downloader, null);
    }

    public ManagedComponentDeployer(ProfileServiceConnection profileServiceConnection, PackageDownloader downloader, ResourceContext<?> parentResourceContext) {
        this.downloader = downloader;
        this.profileServiceConnection = profileServiceConnection;
        this.parentResourceContext = parentResourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(CreateResourceReport createResourceReport, ResourceType resourceType) {
        String archiveName;
        ResourcePackageDetails details;
        File archiveFile;
        block23: {
            createResourceReport.setStatus(null);
            archiveFile = null;
            details = createResourceReport.getPackageDetails();
            PackageDetailsKey key = details.getKey();
            archiveFile = this.downloader.prepareArchive(key, resourceType);
            archiveName = key.getName();
            if (DeploymentUtils.hasCorrectExtension(archiveName, resourceType)) break block23;
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("Incorrect extension specified on filename [" + archiveName + "]");
            if (archiveFile != null) {
                this.downloader.destroyArchive(archiveFile);
            }
            return;
        }
        try {
            DeploymentState state;
            String[] deploymentNames;
            this.abortIfApplicationAlreadyDeployed(resourceType, archiveFile);
            Configuration deployTimeConfig = details.getDeploymentTimeConfiguration();
            boolean deployExploded = deployTimeConfig.getSimple("deployExploded").getBooleanValue();
            DeploymentManager deploymentManager = this.profileServiceConnection.getDeploymentManager();
            boolean deployFarmed = deployTimeConfig.getSimple("deployFarmed").getBooleanValue();
            if (deployFarmed) {
                Collection profileKeys = deploymentManager.getProfiles();
                boolean farmSupported = false;
                for (ProfileKey profileKey : profileKeys) {
                    if (!profileKey.getName().equals(FARM_PROFILE_KEY.getName())) continue;
                    farmSupported = true;
                    break;
                }
                if (!farmSupported) {
                    throw new IllegalStateException("This application server instance is not a node in a cluster, so it does not support farmed deployments. Supported deployment profiles are " + profileKeys + ".");
                }
                if (deployExploded) {
                    throw new IllegalArgumentException("Deploying farmed applications in exploded form is not supported by the Profile Service.");
                }
                deploymentManager.loadProfile(FARM_PROFILE_KEY);
            }
            try {
                deploymentNames = DeploymentUtils.deployArchive(deploymentManager, archiveFile, deployExploded);
            }
            finally {
                if (deployFarmed) {
                    deploymentManager.loadProfile(APPLICATIONS_PROFILE_KEY);
                }
            }
            if (deploymentNames == null || deploymentNames.length != 1) {
                throw new RuntimeException("deploy operation returned invalid result: " + deploymentNames);
            }
            String deploymentName = deploymentNames[0];
            if (deployExploded && this.parentResourceContext != null) {
                URI deploymentURI = URI.create(deploymentName);
                String deploymentPath = deploymentURI.getPath();
                File deploymentFile = new File(deploymentPath);
                FileContentDelegate fileContentDelegate = new FileContentDelegate();
                fileContentDelegate.saveDeploymentSHA(archiveFile, deploymentFile, this.parentResourceContext.getFutureChildResourceDataDirectory(archiveName));
            }
            ManagementView managementView = this.profileServiceConnection.getManagementView();
            managementView.load();
            ManagedDeployment managedDeployment = null;
            try {
                managedDeployment = managementView.getDeployment(deploymentName);
            }
            catch (NoSuchDeploymentException e) {
                LOG.error((Object)("Failed to find managed deployment '" + deploymentName + "' after deploying '" + archiveName + "', so cannot start the application."));
                createResourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                createResourceReport.setErrorMessage("Unable to start application '" + deploymentName + "' after deploying it, since lookup of the associated ManagedDeployment failed.");
            }
            if (managedDeployment != null && (state = managedDeployment.getDeploymentState()) != DeploymentState.STARTED) {
                createResourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                createResourceReport.setErrorMessage("Failed to start application '" + deploymentName + "' after deploying it.");
            }
            createResourceReport.setResourceName(archiveName);
            createResourceReport.setResourceKey(archiveName);
            if (createResourceReport.getStatus() == null) {
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            }
            if (archiveFile != null) {
                this.downloader.destroyArchive(archiveFile);
            }
        }
        catch (Throwable t) {
            try {
                LOG.error((Object)("Error deploying application for request [" + createResourceReport + "]."), t);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException(t);
                if (archiveFile != null) {
                    this.downloader.destroyArchive(archiveFile);
                }
            }
            catch (Throwable throwable) {
                if (archiveFile != null) {
                    this.downloader.destroyArchive(archiveFile);
                }
                throw throwable;
            }
        }
    }

    private void abortIfApplicationAlreadyDeployed(ResourceType resourceType, File archiveFile) throws Exception {
        String archiveFileName = archiveFile.getName();
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        ManagementView managementView = this.profileServiceConnection.getManagementView();
        managementView.load();
        Set managedDeployments = managementView.getDeploymentsForType(deploymentTypeString);
        for (ManagedDeployment managedDeployment : managedDeployments) {
            if (!managedDeployment.getSimpleName().equals(archiveFileName)) continue;
            throw new IllegalArgumentException("An application named '" + archiveFileName + "' is already deployed.");
        }
    }
}

