/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;

@Deprecated
public class FileContentDelegate {
    private static final String RHQ_SHA_256 = "RHQ-Sha256";
    private static final String SHA256_FILE = "application.sha256";
    private final Log log = LogFactory.getLog(FileContentDelegate.class);
    private final String fileEnding;
    private final File directory;

    @Deprecated
    public FileContentDelegate() {
        this.fileEnding = null;
        this.directory = null;
    }

    @Deprecated
    public FileContentDelegate(File directory, String fileEnding) {
        this.directory = directory;
        this.fileEnding = fileEnding;
    }

    @Deprecated
    public String getFileEnding() {
        return this.fileEnding;
    }

    @Deprecated
    public File getDirectory() {
        return this.directory;
    }

    @Deprecated
    public void createContent(PackageDetails details, File content, boolean unzip) {
        File destination = this.getPath(details);
        try {
            if (unzip) {
                ZipUtil.unzipFile((File)content, (File)destination);
            } else {
                FileUtil.copyFile((File)content, (File)destination);
            }
            details.setFileName(destination.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact from details: " + destination, e);
        }
    }

    @Deprecated
    public InputStream getContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + contentFile, e);
        }
    }

    @Deprecated
    public void deleteContent(PackageDetails details) {
        File contentFile = this.getPath(details);
        if (!contentFile.exists()) {
            return;
        }
        try {
            FileUtils.purge((File)contentFile, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete underlying file [" + contentFile + "] for " + details + ".", e);
        }
    }

    @Deprecated
    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        throw new UnsupportedOperationException("This method is not implemented!");
    }

    @Deprecated
    public String retrieveDeploymentSHA(File deployment, File resourceDataDirectory) {
        String sha = null;
        if (deployment.isDirectory()) {
            File propertiesFile = new File(resourceDataDirectory, SHA256_FILE);
            if (propertiesFile.exists()) {
                FileInputStream propertiesInputStream = null;
                try {
                    propertiesInputStream = new FileInputStream(propertiesFile);
                    Properties prop = new Properties();
                    prop.load(propertiesInputStream);
                    sha = prop.getProperty(RHQ_SHA_256);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error retrieving artifact's SHA256.", e);
                }
                finally {
                    if (propertiesInputStream != null) {
                        try {
                            propertiesInputStream.close();
                        }
                        catch (IOException e) {
                            this.log.error((Object)"Failed to close input stream.", (Throwable)e);
                        }
                    }
                }
            }
            if (sha == null) {
                sha = this.saveDeploymentSHA(deployment, resourceDataDirectory);
            }
        } else {
            sha = this.computeSHAForArchivedContent(deployment);
        }
        return sha;
    }

    @Deprecated
    public String saveDeploymentSHA(File originalArchive, File deployment, File resourceDataDirectory) {
        String sha = null;
        if (deployment.isDirectory()) {
            sha = this.computeSHAForArchivedContent(originalArchive);
            this.saveDeploymentSHA(sha, resourceDataDirectory);
        } else {
            sha = this.computeSHAForArchivedContent(deployment);
        }
        return sha;
    }

    @Deprecated
    public String saveDeploymentSHA(File deployment, File resourceDataDirectory) {
        String sha = null;
        if (deployment.isDirectory()) {
            sha = this.computeSHAForExplodedContent(deployment);
            this.saveDeploymentSHA(sha, resourceDataDirectory);
        } else {
            sha = this.computeSHAForArchivedContent(deployment);
        }
        return sha;
    }

    @Deprecated
    private void saveDeploymentSHA(String sha, File resourceDataDirectory) {
        Properties prop = new Properties();
        prop.setProperty(RHQ_SHA_256, sha);
        File propertiesFile = new File(resourceDataDirectory, SHA256_FILE);
        FileOutputStream propertiesOutputStream = null;
        try {
            propertiesOutputStream = new FileOutputStream(propertiesFile);
            prop.store(propertiesOutputStream, null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error saving artifact's SHA256.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving artifact's SHA256.", e);
        }
        finally {
            if (propertiesOutputStream != null) {
                try {
                    propertiesOutputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error saving artifact's SHA256.", e);
                }
            }
        }
    }

    @Deprecated
    private String computeSHAForArchivedContent(File contentFile) {
        if (!contentFile.isDirectory()) {
            try {
                MessageDigestGenerator messageDigest = new MessageDigestGenerator("SHA-256");
                return messageDigest.calcDigestString(contentFile);
            }
            catch (Exception ex) {
                this.log.error((Object)("Not able to compute SHA256 for " + contentFile.getPath() + " ."));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private String computeSHAForExplodedContent(File deploymentDirectory) {
        try {
            if (deploymentDirectory.isDirectory()) {
                MessageDigestGenerator messageDigest = new MessageDigestGenerator("SHA-256");
                Stack<File> unvisitedFolders = new Stack<File>();
                unvisitedFolders.add(deploymentDirectory);
                while (!unvisitedFolders.empty()) {
                    File[] files = ((File)unvisitedFolders.pop()).listFiles();
                    Arrays.sort(files, new Comparator<File>(){

                        @Override
                        public int compare(File f1, File f2) {
                            try {
                                return f1.getCanonicalPath().compareTo(f2.getCanonicalPath());
                            }
                            catch (IOException iOException) {
                                return 0;
                            }
                        }
                    });
                    for (File file : files) {
                        if (file.isDirectory()) {
                            unvisitedFolders.add(file);
                            continue;
                        }
                        FileInputStream inputStream = null;
                        try {
                            inputStream = new FileInputStream(file);
                            messageDigest.add((InputStream)inputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                }
                return messageDigest.getDigestString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact for contentFile: " + deploymentDirectory, e);
        }
        return null;
    }

    @Deprecated
    private File getPath(PackageDetails details) {
        String fileName = details.getKey().getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        if (this.fileEnding != null && !fileName.endsWith(this.fileEnding)) {
            fileName = fileName + this.fileEnding;
        }
        return new File(this.directory, fileName);
    }
}

