/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

public abstract class AbstractManagedDeploymentDiscoveryComponent
implements ResourceDiscoveryComponent<ProfileServiceComponent<?>>,
ResourceUpgradeFacet<ProfileServiceComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ProfileServiceComponent<?>> discoveryContext) {
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        ManagementView managementView = ((ProfileServiceComponent)discoveryContext.getParentResourceComponent()).getConnection().getManagementView();
        managementView.load();
        Set deploymentNames = null;
        try {
            deploymentNames = managementView.getDeploymentNamesForType(deploymentTypeString);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to get deployment names for type " + deploymentTypeString), (Throwable)e);
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(deploymentNames.size());
        ProfileService profileService = ((ProfileServiceComponent)discoveryContext.getParentResourceComponent()).getConnection().getProfileService();
        for (String deploymentName : deploymentNames) {
            try {
                ManagedDeployment managedDeployment = managementView.getDeployment(deploymentName);
                if (!this.accept(managedDeployment)) continue;
                String resourceName = managedDeployment.getSimpleName();
                if (resourceName.equals("%Generated%")) {
                    resourceName = AbstractManagedDeploymentDiscoveryComponent.getResourceName(deploymentName);
                }
                String resourceKey = AbstractManagedDeploymentDiscoveryComponent.buildResourceKey(managedDeployment, profileService);
                managedDeployment.getSimpleName();
                String version = null;
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, version, resourceType.getDescription(), discoveryContext.getDefaultPluginConfiguration(), null);
                resource.getPluginConfiguration().put((Property)new PropertySimple("deploymentName", (Object)deploymentName));
                discoveredResources.add(resource);
            }
            catch (NoSuchDeploymentException e) {
                this.log.error((Object)("ManagementView.getDeploymentNamesForType() returned [" + deploymentName + "] as a deployment name, but calling getDeployment() with that name failed."));
            }
            catch (Exception e) {
                this.log.error((Object)("An error occurred while discovering " + resourceType + " Resources."), (Throwable)e);
            }
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ProfileServiceComponent<?>> upgradeContext) {
        ManagedDeployment deployment;
        String inventoriedResourceKey = upgradeContext.getResourceKey();
        if (inventoriedResourceKey.startsWith("{")) {
            return null;
        }
        ManagementView managementView = ((ProfileServiceComponent)upgradeContext.getParentResourceComponent()).getConnection().getManagementView();
        try {
            deployment = managementView.getDeployment(inventoriedResourceKey);
        }
        catch (NoSuchDeploymentException e) {
            throw new IllegalStateException(e);
        }
        ProfileService profileService = ((ProfileServiceComponent)upgradeContext.getParentResourceComponent()).getConnection().getProfileService();
        String resourceKey = AbstractManagedDeploymentDiscoveryComponent.buildResourceKey(deployment, profileService);
        ResourceUpgradeReport upgradeReport = new ResourceUpgradeReport();
        upgradeReport.setNewResourceKey(resourceKey);
        return upgradeReport;
    }

    private static String buildResourceKey(ManagedDeployment deployment, ProfileService profileService) {
        StringBuilder resourceKey = new StringBuilder();
        String profileName = AbstractManagedDeploymentDiscoveryComponent.getProfileName(deployment, profileService);
        resourceKey.append('{').append(profileName).append("}");
        ArrayList<String> deploymentAncestrySimpleNames = new ArrayList<String>();
        ManagedDeployment parentDeployment = deployment;
        do {
            deploymentAncestrySimpleNames.add(0, parentDeployment.getSimpleName());
        } while ((parentDeployment = parentDeployment.getParent()) != null);
        int deploymentAncestrySimpleNamesSize = deploymentAncestrySimpleNames.size();
        for (int i = 0; i < deploymentAncestrySimpleNamesSize; ++i) {
            String deploymentSimpleName = (String)deploymentAncestrySimpleNames.get(i);
            resourceKey.append(deploymentSimpleName);
            if (i == deploymentAncestrySimpleNamesSize - 1) continue;
            resourceKey.append("/");
        }
        return resourceKey.toString();
    }

    private static String getProfileName(ManagedDeployment deployment, ProfileService profileService) {
        Collection profileKeys = profileService.getActiveProfileKeys();
        for (ProfileKey profileKey : profileKeys) {
            Profile profile;
            try {
                profile = profileService.getActiveProfile(profileKey);
            }
            catch (Exception e) {
                DeploymentManager deploymentManager = profileService.getDeploymentManager();
                try {
                    deploymentManager.loadProfile(profileKey);
                }
                catch (Exception e1) {
                    continue;
                }
                DeploymentState deploymentState = deployment.getDeploymentState();
                try {
                    DeploymentProgress progress = deploymentState == DeploymentState.STARTED || deploymentState == DeploymentState.STARTING ? deploymentManager.start(new String[]{deployment.getName()}) : deploymentManager.stop(new String[]{deployment.getName()});
                    progress.run();
                    DeploymentStatus status = progress.getDeploymentStatus();
                    if (status.isFailed()) {
                    }
                }
                catch (Exception e1) {}
                continue;
                return profileKey.getName();
            }
            if (!profile.hasDeployment(deployment.getName())) continue;
            return profileKey.getName();
        }
        return "default";
    }

    protected abstract boolean accept(ManagedDeployment var1);

    private static String getResourceName(String fullPath) {
        int lastSlashIndex = fullPath.lastIndexOf("/");
        return fullPath.substring(lastSlashIndex + 1);
    }
}

