/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.deploy.Deployer;
import org.rhq.plugins.jbossas5.deploy.LocalDownloader;
import org.rhq.plugins.jbossas5.deploy.ManagedComponentDeployer;
import org.rhq.plugins.jbossas5.deploy.PackageDownloader;
import org.rhq.plugins.jbossas5.deploy.RemoteDownloader;
import org.rhq.plugins.jbossas5.deploy.ScriptDeployer;
import org.rhq.plugins.jbossas5.util.ConversionUtils;
import org.rhq.plugins.jbossas5.util.DebugUtils;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.ResourceComponentUtils;

public class CreateChildResourceFacetDelegate
implements CreateChildResourceFacet {
    private static final String MANAGED_PROPERTY_GROUP = "managedPropertyGroup";
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceComponent component;

    public CreateChildResourceFacetDelegate(ProfileServiceComponent component) {
        this.component = component;
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        ResourceType resourceType = createResourceReport.getResourceType();
        if (resourceType.getCreationDataType() == ResourceCreationDataType.CONTENT) {
            this.createContentBasedResource(createResourceReport, resourceType);
        } else {
            this.createConfigurationBasedResource(createResourceReport, resourceType);
        }
        return createResourceReport;
    }

    void createConfigurationBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        Configuration defaultPluginConfig = CreateChildResourceFacetDelegate.getDefaultPluginConfiguration(resourceType);
        Configuration resourceConfig = createResourceReport.getResourceConfiguration();
        String componentName = CreateChildResourceFacetDelegate.getComponentName(defaultPluginConfig, resourceConfig);
        ComponentType componentType = ConversionUtils.getComponentType(resourceType);
        ManagementView managementView = this.component.getConnection().getManagementView();
        if (ManagedComponentUtils.isManagedComponent(managementView, componentName, componentType)) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("A " + resourceType.getName() + " named '" + componentName + "' already exists.");
            return;
        }
        createResourceReport.setResourceName(componentName);
        createResourceReport.setResourceKey(componentName);
        PropertySimple templateNameProperty = defaultPluginConfig.getSimple("templateName");
        String templateName = templateNameProperty.getStringValue();
        try {
            DeploymentTemplateInfo template = managementView.getTemplate(templateName);
            Map managedProperties = template.getProperties();
            Map<String, PropertySimple> customProps = ResourceComponentUtils.getCustomProperties(defaultPluginConfig);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("BEFORE CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConversionUtils.convertConfigurationToManagedProperties(managedProperties, resourceConfig, resourceType, customProps);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("AFTER CREATE:\n" + DebugUtils.convertPropertiesToString(template)));
            }
            ConfigurationDefinition pluginConfigDef = resourceType.getPluginConfigurationDefinition();
            List managedPropertyGroup = pluginConfigDef.getPropertiesInGroup(MANAGED_PROPERTY_GROUP);
            this.handleMiscManagedProperties(managedPropertyGroup, managedProperties, defaultPluginConfig);
            this.log.debug((Object)("Applying template [" + templateName + "] to create ManagedComponent of type [" + componentType + "]..."));
            try {
                managementView.applyTemplate(componentName, template);
                managementView.process();
                createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to apply template [" + templateName + "] to create ManagedComponent of type " + componentType + "."), (Throwable)e);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException((Throwable)e);
            }
        }
        catch (NoSuchDeploymentException e) {
            this.log.error((Object)("Unable to find template [" + templateName + "]."), (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to process create request", (Throwable)e);
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setException((Throwable)e);
        }
    }

    private void createContentBasedResource(CreateResourceReport createResourceReport, ResourceType resourceType) {
        this.getDeployer(resourceType).deploy(createResourceReport, resourceType);
    }

    private static String getComponentName(Configuration pluginConfig, Configuration resourceConfig) {
        PropertySimple componentNameProp = pluginConfig.getSimple("componentNameProperty");
        if (componentNameProp == null || componentNameProp.getStringValue() == null) {
            throw new IllegalStateException("Property [componentNameProperty] is not defined in the default plugin configuration.");
        }
        String componentNamePropName = componentNameProp.getStringValue();
        PropertySimple propToUseAsComponentName = resourceConfig.getSimple(componentNamePropName);
        if (propToUseAsComponentName == null) {
            throw new IllegalStateException("Property [" + componentNamePropName + "] is not defined in user-specified initial Resource configuration.");
        }
        return propToUseAsComponentName.getStringValue();
    }

    private Deployer getDeployer(ResourceType resourceType) {
        PackageDownloader downloader;
        ProfileServiceConnection profileServiceConnection = this.component.getConnection();
        PackageDownloader packageDownloader = downloader = this.runningEmbedded() ? new LocalDownloader() : new RemoteDownloader(this.component.getResourceContext(), false, profileServiceConnection);
        if ("Script".equals(resourceType.getName())) {
            String jbossHome = this.component.getResourceContext().getPluginConfiguration().getSimpleValue("homeDir", null);
            SystemInfo systemInfo = this.component.getResourceContext().getSystemInformation();
            return new ScriptDeployer(jbossHome, systemInfo, downloader);
        }
        return new ManagedComponentDeployer(profileServiceConnection, downloader);
    }

    private boolean runningEmbedded() {
        Configuration pluginConfiguration = this.component.getResourceContext().getPluginConfiguration();
        String namingUrl = pluginConfiguration.getSimpleValue("namingURL", null);
        return namingUrl == null;
    }

    private static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate pluginConfigDefaultTemplate = resourceType.getPluginConfigurationDefinition().getDefaultTemplate();
        return pluginConfigDefaultTemplate != null ? pluginConfigDefaultTemplate.createConfiguration() : new Configuration();
    }

    private void handleMiscManagedProperties(Collection<PropertyDefinition> managedPropertyGroup, Map<String, ManagedProperty> managedProperties, Configuration pluginConfiguration) {
        for (PropertyDefinition propertyDefinition : managedPropertyGroup) {
            String propertyKey = propertyDefinition.getName();
            Property property = pluginConfiguration.get(propertyKey);
            ManagedProperty managedProperty = managedProperties.get(propertyKey);
            if (managedProperty == null || property == null) continue;
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(managedProperty.getMetaType());
            propertyAdapter.populateMetaValueFromProperty(property, managedProperty.getValue(), propertyDefinition);
        }
    }
}

