/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentComponent;
import org.rhq.plugins.jbossas5.WebApplicationContextDiscoveryComponent;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

public class WarMeasurementFacetDelegate
implements MeasurementFacet {
    private static final String CONTEXT_ROOT_TRAIT = "contextRoot";
    private static final String VIRTUAL_HOSTS_TRAIT = "virtualHosts";
    private static final String CONTEXT_COMPONENT_NAME = "ContextMO";
    private final Log log = LogFactory.getLog(this.getClass());
    private AbstractManagedDeploymentComponent managedDeploymentComponent;

    public WarMeasurementFacetDelegate(AbstractManagedDeploymentComponent managedDeploymentComponent) {
        this.managedDeploymentComponent = managedDeploymentComponent;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ManagementView managementView = this.managedDeploymentComponent.getConnection().getManagementView();
        String contextPath = this.getContextPath();
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                if (metricName.equals(CONTEXT_ROOT_TRAIT)) {
                    if (contextPath == null) continue;
                    String contextRoot = contextPath.equals("/") ? "/" : contextPath.substring(1);
                    MeasurementDataTrait trait = new MeasurementDataTrait(request, contextRoot);
                    report.addData(trait);
                    continue;
                }
                if (!metricName.equals(VIRTUAL_HOSTS_TRAIT) || contextPath == null) continue;
                Set<String> virtualHosts = WebApplicationContextDiscoveryComponent.getVirtualHosts(contextPath, managementView);
                String value = "";
                Iterator<String> iterator = virtualHosts.iterator();
                while (iterator.hasNext()) {
                    String virtualHost = iterator.next();
                    value = value + virtualHost;
                    if (!iterator.hasNext()) continue;
                    value = value + ", ";
                }
                MeasurementDataTrait trait = new MeasurementDataTrait(request, value);
                report.addData(trait);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to collect metric '" + metricName + "' for " + this.managedDeploymentComponent.getResourceDescription() + "."), (Throwable)e);
            }
        }
    }

    @Nullable
    private String getContextPath() throws NoSuchDeploymentException {
        ManagedDeployment deployment = this.managedDeploymentComponent.getManagedDeployment();
        ManagedComponent contextComponent = deployment.getComponent(CONTEXT_COMPONENT_NAME);
        if (contextComponent != null) {
            return (String)((Object)ManagedComponentUtils.getSimplePropertyValue(contextComponent, CONTEXT_ROOT_TRAIT));
        }
        return null;
    }
}

