/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASTomcatConnectorDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String LOCAL_IP = "0.0.0.0";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        ObjectNameQueryUtility queryUtility;
        Set resourceDetails = super.discoverResources(context);
        EmsConnection connection = ((JMXComponent)context.getParentResourceComponent()).getEmsConnection();
        List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility("jboss.web:type=GlobalRequestProcessor,name=%name%")).getTranslatedQuery());
        if (beans.size() != resourceDetails.size()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"jboss.web:type=GlobalRequestProcessor,name=* MBeans are not fully deployed yet - aborting...");
            }
            return Collections.emptySet();
        }
        HashMap<String, String> schemaMap = new HashMap<String, String>(beans.size());
        HashMap<String, Boolean> addressPresentMap = new HashMap<String, Boolean>(beans.size());
        for (EmsBean bean : beans) {
            EmsBeanName eName = bean.getBeanName();
            String oName = eName.getKeyProperty("name");
            String[] comps = oName.split("-");
            if (comps.length == 2) {
                schemaMap.put(comps[1], comps[0]);
                addressPresentMap.put(comps[1], false);
                continue;
            }
            if (comps.length == 3) {
                schemaMap.put(comps[2], comps[0]);
                addressPresentMap.put(comps[2], true);
                continue;
            }
            this.log.warn((Object)("Unknown ObjectName for GlobalRequestProcessor: " + oName));
        }
        for (DiscoveredResourceDetails resource : resourceDetails) {
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String dirtyAddress = pluginConfiguration.getSimple("address").getStringValue();
            String port = pluginConfiguration.getSimple("port").getStringValue();
            boolean portHasAddress = Boolean.TRUE.equals(addressPresentMap.get(port));
            if (dirtyAddress.startsWith("%2F")) {
                String cleanAddress = dirtyAddress.substring(3);
                if (portHasAddress) {
                    pluginConfiguration.put((Property)new PropertySimple("address", (Object)cleanAddress));
                    pluginConfiguration.put((Property)new PropertySimple("-", (Object)"-"));
                } else {
                    pluginConfiguration.put((Property)new PropertySimple("address", (Object)""));
                    pluginConfiguration.put((Property)new PropertySimple("-", (Object)""));
                }
                String dirtyResourceKey = resource.getResourceKey();
                String cleanResourceKey = dirtyResourceKey.replace(dirtyAddress, cleanAddress);
                resource.setResourceKey(cleanResourceKey);
                String resourceName = resource.getResourceName();
                if (!cleanAddress.equals(LOCAL_IP)) {
                    resourceName = resourceName.replace("(", " (" + cleanAddress + ":");
                    resource.setResourceName(resourceName);
                }
            } else if (portHasAddress) {
                pluginConfiguration.put((Property)new PropertySimple("-", (Object)"-"));
            } else {
                pluginConfiguration.put((Property)new PropertySimple("address", (Object)""));
                pluginConfiguration.put((Property)new PropertySimple("-", (Object)""));
            }
            String schema = (String)schemaMap.get(port);
            pluginConfiguration.put((Property)new PropertySimple("schema", (Object)schema));
            this.log.debug((Object)("Found a connector: " + schema + "-" + dirtyAddress + ":" + port));
        }
        return resourceDetails;
    }
}

