/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import com.jboss.jbossnetwork.product.jbpm.handlers.InPluginControlActionFacade;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.jboss.on.common.jbossas.JBossASPaths;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.ApplicationServerComponent;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.support.SnapshotReportRequest;
import org.rhq.core.pluginapi.support.SnapshotReportResults;
import org.rhq.core.pluginapi.support.SupportFacet;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.plugins.jbossas.JBossASServerOperationsDelegate;
import org.rhq.plugins.jbossas.JBossASServerSupportedOperations;
import org.rhq.plugins.jbossas.helper.MainDeployer;
import org.rhq.plugins.jbossas.util.ConnectionFactoryConfigurationEditor;
import org.rhq.plugins.jbossas.util.DatasourceConfigurationEditor;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.FileContentDelegate;
import org.rhq.plugins.jbossas.util.FileNameUtility;
import org.rhq.plugins.jbossas.util.JBossASContentFacetDelegate;
import org.rhq.plugins.jbossas.util.JBossASSnapshotReport;
import org.rhq.plugins.jbossas.util.JarContentDelegate;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASServerComponent
implements MeasurementFacet,
OperationFacet,
JMXComponent,
CreateChildResourceFacet,
ApplicationServerComponent,
ContentFacet,
SupportFacet {
    private static final String LOCALHOST = "localhost";
    public static final String NAMING_URL_CONFIG_PROP = "namingURL";
    public static final String JBOSS_HOME_DIR_CONFIG_PROP = "jbossHomeDir";
    public static final String CONFIGURATION_PATH_CONFIG_PROP = "configurationPath";
    public static final String SCRIPT_PREFIX_CONFIG_PROP = "scriptPrefix";
    public static final String CONFIGURATION_SET_CONFIG_PROP = "configurationSet";
    public static final String START_SCRIPT_CONFIG_PROP = "startScript";
    public static final String SHUTDOWN_SCRIPT_CONFIG_PROP = "shutdownScript";
    public static final String SHUTDOWN_MBEAN_CONFIG_PROP = "shutdownMbeanName";
    public static final String SHUTDOWN_MBEAN_OPERATION_CONFIG_PROP = "shutdownMbeanOperation";
    public static final String SHUTDOWN_METHOD_CONFIG_PROP = "shutdownMethod";
    public static final String JAVA_HOME_PATH_CONFIG_PROP = "javaHomePath";
    public static final String AVAIL_CHECK_PERIOD_CONFIG_PROP = "availabilityCheckPeriod";
    public static final String BINDING_ADDRESS_CONFIG_PROP = "bindingAddress";
    static final String DEFAULT_START_SCRIPT = "bin" + File.separator + "run." + (File.separatorChar == '/' ? "sh" : "bat");
    static final String DEFAULT_SHUTDOWN_SCRIPT = "bin" + File.separator + "shutdown." + (File.separatorChar == '/' ? "sh" : "bat");
    static final String DEFAULT_JAVA_HOME = System.getProperty("java.home");
    static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    private static final String RESOURCE_TYPE_DATASOURCE = "Datasource";
    private static final String RESOURCE_TYPE_CONNECTION_FACTORY = "ConnectionFactory";
    private static final String RESOURCE_TYPE_EAR = "Enterprise Application (EAR)";
    private static final String RESOURCE_TYPE_WAR = "Web Application (WAR)";
    private static final String RESOURCE_TYPE_SAR = "Service Archive (SAR)";
    private static final String PACKAGE_TYPE_PATCH = "cumulativePatch";
    private static final String PACKAGE_TYPE_LIBRARY = "library";
    private static final String JNP_DISABLE_DISCOVERY_JNP_INIT_PROP = "jnp.disableDiscovery";
    private static final String DISTRIBUTED_REPLICANT_MANAGER_MBEAN_NAME_TEMPLATE = "jboss:partitionName=%partitionName%,service=DistributedReplicantManager";
    private static final int JNP_TIMEOUT = 30000;
    private static final int JNP_SO_TIMEOUT = 15000;
    private final Log log = LogFactory.getLog(JBossASServerComponent.class);
    private ResourceContext resourceContext;
    private ContentContext contentContext;
    private JBossASContentFacetDelegate contentFacetDelegate;
    private EmsConnection connection;
    private File configPath;
    private String configSet;
    private final Map<PackageType, FileContentDelegate> contentDelegates = new HashMap<PackageType, FileContentDelegate>();
    private JBossASServerOperationsDelegate operationsDelegate;
    private LogFileEventResourceComponentHelper logFileEventDelegate;
    private int consecutiveConnectionErrors;
    private MainDeployer mainDeployer;
    private AvailabilityCollectorRunnable availCollector;
    private boolean loggedHijackedJnpUrlError;

    public void start(ResourceContext context) throws Exception {
        Configuration pluginConfig;
        block6: {
            this.resourceContext = context;
            this.contentContext = context.getContentContext();
            this.operationsDelegate = new JBossASServerOperationsDelegate(this, this.resourceContext.getSystemInformation());
            this.validatePluginConfiguration();
            pluginConfig = context.getPluginConfiguration();
            this.configPath = this.resolvePathRelativeToHomeDir(JBossASServerComponent.getRequiredPropertyValue(pluginConfig, CONFIGURATION_PATH_CONFIG_PROP));
            if (!this.configPath.exists()) {
                throw new InvalidPluginConfigurationException("Configuration path '" + this.configPath + "' does not exist.");
            }
            this.configSet = pluginConfig.getSimpleValue(CONFIGURATION_SET_CONFIG_PROP, this.configPath.getName());
            InPluginControlActionFacade controlFacade = new InPluginControlActionFacade(this);
            JBossASPaths jbossPaths = new JBossASPaths();
            jbossPaths.setHomeDir(this.getPluginConfiguration().getSimpleValue(JBOSS_HOME_DIR_CONFIG_PROP, null));
            jbossPaths.setServerDir(this.getPluginConfiguration().getSimpleValue(CONFIGURATION_PATH_CONFIG_PROP, null));
            JBPMWorkflowManager workflowManager = new JBPMWorkflowManager(this.contentContext, (ControlActionFacade)controlFacade, jbossPaths);
            this.contentFacetDelegate = new JBossASContentFacetDelegate(workflowManager, this.configPath);
            try {
                this.loadConnection();
            }
            catch (Exception e) {
                Throwable cause;
                if (!(e instanceof EmsConnectException) || !((cause = e.getCause()) instanceof SecurityException)) break block6;
                throw new InvalidPluginConfigurationException("Invalid JMX credentials specified for connecting to this server.", (Throwable)e);
            }
        }
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.resourceContext);
        this.logFileEventDelegate.startLogFileEventPollers();
        String availCheckPeriodProp = pluginConfig.getSimpleValue(AVAIL_CHECK_PERIOD_CONFIG_PROP, null);
        if (availCheckPeriodProp != null) {
            try {
                long availCheckMillis = (long)Integer.parseInt(availCheckPeriodProp) * 1000L;
                this.availCollector = this.resourceContext.createAvailabilityCollectorRunnable(new AvailabilityFacet(){

                    public AvailabilityType getAvailability() {
                        return JBossASServerComponent.this.getAvailabilityNow();
                    }
                }, availCheckMillis);
                this.availCollector.start();
            }
            catch (NumberFormatException nfe) {
                this.log.error((Object)("avail check period config prop was not a valid number. Cause: " + nfe));
                this.availCollector = null;
            }
        }
    }

    public void stop() {
        if (this.availCollector != null) {
            this.availCollector.stop();
            this.availCollector = null;
        }
        this.logFileEventDelegate.stopLogFileEventPollers();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.error((Object)("Error closing JBoss AS connection: " + e));
            }
            this.connection = null;
        }
        this.loggedHijackedJnpUrlError = false;
    }

    public AvailabilityType getAvailability() {
        if (this.availCollector != null) {
            return this.availCollector.getLastKnownAvailability();
        }
        return this.getAvailabilityNow();
    }

    private AvailabilityType getAvailabilityNow() {
        try {
            File serverHomeViaJnp = this.getServerHome();
            if (this.configPath.getCanonicalPath().equals(serverHomeViaJnp.getCanonicalPath())) {
                this.loggedHijackedJnpUrlError = false;
                return AvailabilityType.UP;
            }
            if (!this.loggedHijackedJnpUrlError) {
                String namingURL = this.resourceContext.getPluginConfiguration().getSimpleValue(NAMING_URL_CONFIG_PROP, null);
                String message = "Availability check for JBoss AS Resource with configPath [" + this.configPath + "] has connected to a different running JBoss AS instance which is installed at [" + serverHomeViaJnp + "] using namingURL [" + namingURL + "] - returning AvailabilityType.DOWN...";
                this.log.error((Object)message);
                this.loggedHijackedJnpUrlError = true;
                throw new RuntimeException(message);
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    private File getServerHome() throws Exception {
        File serverHomeViaJnp;
        EmsConnection connection = this.loadConnection();
        EmsBean bean = connection.getBean("jboss.system:type=ServerConfig");
        EmsAttribute serverHomeDirAttrib = bean.getAttribute("ServerHomeDir");
        if (serverHomeDirAttrib != null) {
            serverHomeViaJnp = (File)serverHomeDirAttrib.refresh();
        } else {
            EmsAttribute serverHomeLocationAttrib = bean.getAttribute("ServerHomeLocation");
            URL serverHomeLocation = (URL)serverHomeLocationAttrib.refresh();
            serverHomeViaJnp = JBossASServerComponent.toFile(serverHomeLocation);
        }
        return serverHomeViaJnp;
    }

    private static File toFile(URL url) {
        File file;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(url.getPath());
        }
        return file;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            if (name.equals("partitionName")) {
                String partitionName = this.getPartitionName();
                if (partitionName == null) continue;
                report.addData(new MeasurementDataTrait(request, partitionName));
                continue;
            }
            int delimIndex = name.lastIndexOf(58);
            String beanName = name.substring(0, delimIndex);
            String attributeName = name.substring(delimIndex + 1);
            try {
                EmsConnection emsConnection = this.loadConnection();
                EmsBean bean = emsConnection.getBean(beanName);
                EmsAttribute attribute = bean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                if (valueObject instanceof Number) {
                    Number value = (Number)valueObject;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
                    continue;
                }
                report.addData(new MeasurementDataTrait(request, valueObject.toString()));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration configuration) throws InterruptedException {
        JBossASServerSupportedOperations operation = Enum.valueOf(JBossASServerSupportedOperations.class, name.toUpperCase());
        return this.operationsDelegate.invoke(operation, configuration);
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.generateInstallationSteps(packageDetails);
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        return this.contentFacetDelegate.deployPackages(packages, contentServices);
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        return this.contentFacetDelegate.removePackages(packages);
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        return this.contentFacetDelegate.discoverDeployedPackages(type);
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        return this.contentFacetDelegate.retrievePackageBits(packageDetails);
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        block5: {
            String resourceTypeName = report.getResourceType().getName();
            try {
                if (resourceTypeName.equals(RESOURCE_TYPE_DATASOURCE)) {
                    this.datasourceCreate(report);
                    break block5;
                }
                if (resourceTypeName.equals(RESOURCE_TYPE_CONNECTION_FACTORY)) {
                    this.connectionFactoryCreate(report);
                    break block5;
                }
                if (resourceTypeName.equals(RESOURCE_TYPE_EAR) || resourceTypeName.equals(RESOURCE_TYPE_WAR)) {
                    this.earWarCreate(report, resourceTypeName);
                    break block5;
                }
                throw new UnsupportedOperationException("Unknown Resource type: " + resourceTypeName);
            }
            catch (Exception e) {
                JBossASServerComponent.setErrorOnCreateResourceReport(report, e);
            }
        }
        return report;
    }

    public SnapshotReportResults getSnapshotReport(SnapshotReportRequest request) throws Exception {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String tmpDir = this.resourceContext.getTemporaryDirectory().getAbsolutePath();
        JBossASSnapshotReport report = new JBossASSnapshotReport(request.getName(), request.getDescription(), pluginConfig, this.configPath.getCanonicalPath(), tmpDir);
        File reportFile = report.generate();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(reportFile));
        SnapshotReportResults results = new SnapshotReportResults((InputStream)inputStream);
        return results;
    }

    public EmsConnection getEmsConnection() {
        EmsConnection emsConnection = null;
        try {
            emsConnection = this.loadConnection();
        }
        catch (Exception e) {
            this.log.error((Object)"Component attempting to access a connection that could not be loaded");
        }
        return emsConnection;
    }

    @NotNull
    public File getConfigurationPath() {
        return this.configPath;
    }

    public Configuration getPluginConfiguration() {
        return this.resourceContext.getPluginConfiguration();
    }

    public File getDeploymentFilePath(String objectName) {
        return DeploymentUtility.getDescriptorFile(this.connection, objectName);
    }

    public String getConfigurationSet() {
        return this.configSet;
    }

    @NotNull
    public File getStartScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String startScript = pluginConfig.getSimpleValue(START_SCRIPT_CONFIG_PROP, DEFAULT_START_SCRIPT);
        File startScriptFile = this.resolvePathRelativeToHomeDir(startScript);
        return startScriptFile;
    }

    @NotNull
    public File getShutdownScriptPath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String shutdownScript = pluginConfig.getSimpleValue(SHUTDOWN_SCRIPT_CONFIG_PROP, DEFAULT_SHUTDOWN_SCRIPT);
        File shutdownScriptFile = this.resolvePathRelativeToHomeDir(shutdownScript);
        return shutdownScriptFile;
    }

    @Nullable
    public File getJavaHomePath() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String javaHomePath = pluginConfig.getSimpleValue(JAVA_HOME_PATH_CONFIG_PROP, DEFAULT_JAVA_HOME);
        if (javaHomePath == null) {
            this.log.warn((Object)"The 'java.home' System property is not set - unable to set default value for the 'javaHomePath' connection property.");
        }
        File javaHome = javaHomePath != null ? new File(javaHomePath) : null;
        return javaHome;
    }

    @NotNull
    public String getBindingAddress() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String bindingAddress = pluginConfig.getSimpleValue(BINDING_ADDRESS_CONFIG_PROP, DEFAULT_BIND_ADDRESS);
        return bindingAddress;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    private FileContentDelegate getContentDelegate(PackageType type) {
        FileContentDelegate contentDelegate = this.contentDelegates.get(type);
        if (contentDelegate == null) {
            if (type.getName().equals(PACKAGE_TYPE_LIBRARY)) {
                File configurationPath = this.getConfigurationPath();
                File deployLib = new File(configurationPath, "lib");
                contentDelegate = new JarContentDelegate(deployLib, type.getName());
            }
            this.contentDelegates.put(type, contentDelegate);
        }
        return contentDelegate;
    }

    private void validatePluginConfiguration() {
        this.validateJBossHomeDirProperty();
        this.validateJavaHomePathProperty();
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String principal = pluginConfig.getSimpleValue("principal", null);
        String credentials = pluginConfig.getSimpleValue("credentials", null);
        if (principal != null && credentials == null) {
            throw new InvalidPluginConfigurationException("If the 'principal' connection property is set, the 'credentials' connection property must also be set.");
        }
        if (credentials != null && principal == null) {
            throw new InvalidPluginConfigurationException("If the 'credentials' connection property is set, the 'principal' connection property must also be set.");
        }
    }

    void validateJBossHomeDirProperty() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String jbossHome = JBossASServerComponent.getRequiredPropertyValue(pluginConfig, JBOSS_HOME_DIR_CONFIG_PROP);
        File jbossHomeDir = new File(jbossHome);
        if (!jbossHomeDir.isAbsolute()) {
            throw new InvalidPluginConfigurationException("jbossHomeDir connection property ('" + jbossHomeDir + "') is not an absolute path. Note, on Windows, absolute paths must start with the drive letter (e.g. C:).");
        }
        if (!jbossHomeDir.exists()) {
            throw new InvalidPluginConfigurationException("jbossHomeDir connection property ('" + jbossHomeDir + "') does not exist.");
        }
        if (!jbossHomeDir.isDirectory()) {
            throw new InvalidPluginConfigurationException("jbossHomeDir connection property ('" + jbossHomeDir + "') is a file, not a directory.");
        }
    }

    void validateJavaHomePathProperty() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String javaHome = pluginConfig.getSimpleValue(JAVA_HOME_PATH_CONFIG_PROP, null);
        if (javaHome != null) {
            File javaHomeDir = new File(javaHome);
            if (!javaHomeDir.isAbsolute()) {
                throw new InvalidPluginConfigurationException("javaHomePath connection property ('" + javaHomeDir + "') is not an absolute path. Note, on Windows, absolute paths must start with the drive letter (e.g. C:).");
            }
            if (!javaHomeDir.exists()) {
                throw new InvalidPluginConfigurationException("javaHomePath connection property ('" + javaHomeDir + "') does not exist.");
            }
            if (!javaHomeDir.isDirectory()) {
                throw new InvalidPluginConfigurationException("javaHomePath connection property ('" + javaHomeDir + "') is not a directory.");
            }
        }
    }

    private void datasourceCreate(CreateResourceReport report) throws Exception {
        Configuration config = report.getResourceConfiguration();
        String name = config.getSimple("jndi-name").getStringValue();
        if (DeploymentUtility.isDuplicateJndiName(this.connection, "jboss.jca:service=DataSourceBinding", name)) {
            report.setStatus(CreateResourceStatus.FAILURE);
            String errorMessage = this.getDuplicateJndiNameErrorMessage(report.getResourceType().getName(), name);
            report.setErrorMessage(errorMessage);
            return;
        }
        File deployDir = new File(this.getConfigurationPath(), "deploy");
        File dsFile = new File(deployDir, FileNameUtility.formatFileName(name) + "-ds.xml");
        DatasourceConfigurationEditor.updateDatasource(dsFile, name, report);
        this.deployFile(dsFile);
        String objectName = String.format("jboss.jca:name=%s,service=DataSourceBinding", name);
        report.setResourceKey(JBossASServerComponent.getCanonicalName(objectName));
        this.setResourceName(report, name);
    }

    private void connectionFactoryCreate(CreateResourceReport report) throws MainDeployer.DeployerException {
        Configuration config = report.getResourceConfiguration();
        String name = config.getSimple("jndi-name").getStringValue();
        if (DeploymentUtility.isDuplicateJndiName(this.connection, "jboss.jca:service=ManagedConnectionPool", name)) {
            String errorMessage = this.getDuplicateJndiNameErrorMessage(report.getResourceType().getName(), name);
            JBossASServerComponent.setErrorOnCreateResourceReport(report, errorMessage, null);
            return;
        }
        File deployDir = new File(this.getConfigurationPath(), "deploy");
        File dsFile = new File(deployDir, FileNameUtility.formatFileName(name) + "-ds.xml");
        ConnectionFactoryConfigurationEditor.updateConnectionFactory(dsFile, name, report);
        this.deployFile(dsFile);
        String objectName = String.format("jboss.jca:name=%s,service=ConnectionFactoryBinding", name);
        report.setResourceKey(JBossASServerComponent.getCanonicalName(objectName));
        this.setResourceName(report, name);
    }

    static void setErrorOnCreateResourceReport(CreateResourceReport report, String message) {
        JBossASServerComponent.setErrorOnCreateResourceReport(report, message, null);
    }

    static void setErrorOnCreateResourceReport(CreateResourceReport report, Exception e) {
        JBossASServerComponent.setErrorOnCreateResourceReport(report, null, e);
    }

    static void setErrorOnCreateResourceReport(CreateResourceReport report, String message, Exception e) {
        report.setStatus(CreateResourceStatus.FAILURE);
        report.setErrorMessage(message);
        report.setException((Throwable)e);
    }

    void deployFile(File file) throws MainDeployer.DeployerException {
        this.getEmsConnection();
        if (this.connection == null) {
            this.log.warn((Object)("Unable to deploy " + file + ", because we could not connect to the JBoss instance."));
            return;
        }
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Unable to deploy " + file + ", because MainDeployer MBean could " + "not be accessed - this should never happen.");
        }
        this.mainDeployer.deploy(file);
    }

    void redeployFile(File file) throws MainDeployer.DeployerException {
        this.getEmsConnection();
        if (this.connection == null) {
            this.log.warn((Object)("Unable to redeploy " + file + ", because we could not connect to the JBoss instance."));
            return;
        }
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Unable to redeploy " + file + ", because MainDeployer MBean could " + "not be accessed - this should never happen.");
        }
        this.mainDeployer.redeploy(file);
    }

    void undeployFile(File file) throws MainDeployer.DeployerException {
        this.getEmsConnection();
        if (this.connection == null) {
            this.log.warn((Object)("Unable to undeploy " + file + ", because we could not connect to the JBoss instance."));
            return;
        }
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Unable to undeploy " + file + ", because MainDeployer MBean could " + "not be accessed - this should never happen.");
        }
        this.mainDeployer.undeploy(file);
    }

    private String getDuplicateJndiNameErrorMessage(String resourceTypeName, String name) {
        return "Duplicate JNDI Name: " + name + " - a " + resourceTypeName + " with that name already exists.";
    }

    private static String getCanonicalName(String objectName) {
        ObjectName on;
        try {
            on = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Malformed JMX object name: " + objectName + " - " + e.getLocalizedMessage());
        }
        return on.getCanonicalName();
    }

    private void setResourceName(CreateResourceReport report, String baseName) {
        String resourceName = report.getUserSpecifiedResourceName() != null ? report.getUserSpecifiedResourceName() : baseName + " " + report.getResourceType().getName();
        report.setResourceName(resourceName);
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        return JBossASServerComponent.resolvePathRelativeToHomeDir(this.resourceContext.getPluginConfiguration(), path);
    }

    @NotNull
    static File resolvePathRelativeToHomeDir(Configuration pluginConfig, @NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String jbossHomeDir = JBossASServerComponent.getRequiredPropertyValue(pluginConfig, JBOSS_HOME_DIR_CONFIG_PROP);
            configDir = new File(jbossHomeDir, path);
        }
        return configDir;
    }

    @NotNull
    private static String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    @NotNull
    public JBossASServerOperationsDelegate getOperationsDelegate() {
        return this.operationsDelegate;
    }

    private void earWarCreate(CreateResourceReport report, String resourceTypeName) throws Exception {
        String resourceKey;
        ResourcePackageDetails details = report.getPackageDetails();
        PackageDetailsKey key = details.getKey();
        String archiveName = key.getName();
        String expectedExtension = resourceTypeName.equals(RESOURCE_TYPE_EAR) ? "ear" : "war";
        int lastPeriod = archiveName.lastIndexOf(".");
        String extension = archiveName.substring(lastPeriod + 1);
        if (lastPeriod == -1 || !expectedExtension.equals(extension)) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Incorrect extension specified on filename [" + archiveName + "]. Expected [" + expectedExtension + "]");
            return;
        }
        Configuration deployTimeConfiguration = details.getDeploymentTimeConfiguration();
        String deployDirectory = deployTimeConfiguration.getSimple("deployDirectory").getStringValue();
        if (deployDirectory == null) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Property 'deployDirectory' was unexpectedly null");
            return;
        }
        File relativeDeployDir = new File(deployDirectory);
        if (relativeDeployDir.isAbsolute()) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Path to deploy (deployDirectory) must be a relative path. Path specified: " + deployDirectory);
            return;
        }
        if (deployDirectory.contains("..")) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Path to deploy (deployDirectory) may not reference the parent directory. Path specified: " + deployDirectory);
            return;
        }
        boolean createBackup = false;
        PropertySimple backupProperty = deployTimeConfiguration.getSimple("createBackup");
        if (backupProperty != null && backupProperty.getBooleanValue() != null && backupProperty.getBooleanValue().booleanValue()) {
            createBackup = true;
        }
        File deployDir = new File(this.getConfigurationPath(), deployDirectory);
        FileContentDelegate deployer = new FileContentDelegate(deployDir, "", details.getPackageTypeName());
        File path = deployer.getPath((PackageDetails)details);
        if (!createBackup && path.exists()) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "A " + resourceTypeName + " file named " + path.getName() + " is already deployed with path " + path + ".");
            return;
        }
        PropertySimple zipProperty = deployTimeConfiguration.getSimple("deployZipped");
        if (zipProperty == null || zipProperty.getBooleanValue() == null) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Zipped property is required.");
            return;
        }
        boolean zip = zipProperty.getBooleanValue();
        File tempDir = this.resourceContext.getTemporaryDirectory();
        File tempFile = new File(tempDir.getAbsolutePath(), "ear_war.bin");
        BufferedOutputStream osForTempDir = new BufferedOutputStream(new FileOutputStream(tempFile));
        ContentServices contentServices = this.contentContext.getContentServices();
        contentServices.downloadPackageBitsForChildResource(this.contentContext, resourceTypeName, key, (OutputStream)osForTempDir);
        ((OutputStream)osForTempDir).close();
        boolean valid = this.isOfType(tempFile, resourceTypeName);
        if (!valid) {
            JBossASServerComponent.setErrorOnCreateResourceReport(report, "Expected a " + resourceTypeName + " file, but its format/content did not match");
            return;
        }
        BufferedInputStream isForTempDir = new BufferedInputStream(new FileInputStream(tempFile));
        new MessageDigestGenerator("SHA-256");
        String shaString = MessageDigestGenerator.getDigestString((File)tempFile);
        deployer.createContent((PackageDetails)details, isForTempDir, !zip, createBackup, shaString);
        String vhost = null;
        if (resourceTypeName.equals(RESOURCE_TYPE_WAR)) {
            vhost = this.getVhostFromWarFile(tempFile);
        }
        if (resourceTypeName.equals(RESOURCE_TYPE_EAR)) {
            resourceKey = "jboss.management.local:J2EEServer=Local,j2eeType=J2EEApplication,name=" + archiveName;
        } else {
            resourceKey = "jboss.management.local:J2EEApplication=null,J2EEServer=Local,j2eeType=WebModule,name=" + archiveName;
            if (!LOCALHOST.equals(vhost)) {
                resourceKey = resourceKey + ",vhost=" + vhost;
            }
        }
        report.setResourceName(archiveName);
        report.setResourceKey(resourceKey);
        report.setStatus(CreateResourceStatus.SUCCESS);
        try {
            this.deployFile(path);
        }
        catch (MainDeployer.DeployerException e) {
            this.log.debug((Object)("Failed to deploy [" + path + "] - undeploying and deleting [" + path + "]..."));
            try {
                this.undeployFile(path);
                FileUtils.purge((File)path, (boolean)true);
            }
            catch (Exception e1) {
                this.log.error((Object)("Failed to rollback deployment of [" + path + "]."), (Throwable)e1);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVhostFromWarFile(File warFile) {
        JarFile jfile = null;
        try {
            jfile = new JarFile(warFile);
            JarEntry entry = jfile.getJarEntry("WEB-INF/jboss-web.xml");
            if (entry != null) {
                SAXBuilder saxBuilder = new SAXBuilder();
                InputStream is = jfile.getInputStream(entry);
                Document doc = saxBuilder.build(is);
                Element root = doc.getRootElement();
                List vHosts = root.getChildren("virtual-host");
                if (vHosts == null || vHosts.isEmpty()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"No vhosts found in war file, using localhost");
                    }
                    String string = LOCALHOST;
                    return string;
                }
                Element vhost = (Element)vHosts.get(0);
                String string = vhost.getText();
                return string;
            }
        }
        catch (Exception ioe) {
            this.log.warn((Object)("Exception when getting vhost from war file : " + ioe.getMessage()));
        }
        finally {
            if (jfile != null) {
                try {
                    jfile.close();
                }
                catch (IOException e) {
                    this.log.info((Object)("Exception when trying to close the war file: " + e.getMessage()));
                }
            }
        }
        return LOCALHOST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOfType(File file, String type) {
        JarFile jfile = null;
        try {
            JarEntry entry;
            jfile = new JarFile(file);
            if (RESOURCE_TYPE_WAR.equals(type)) {
                entry = jfile.getJarEntry("WEB-INF/web.xml");
            } else if (RESOURCE_TYPE_EAR.equals(type)) {
                entry = jfile.getJarEntry("META-INF/application.xml");
            } else if (RESOURCE_TYPE_SAR.equals(type)) {
                entry = jfile.getJarEntry("META-INF/jboss-service.xml");
            } else {
                entry = null;
                this.log.warn((Object)("isOfType: " + type + " is unknown - not a valid file"));
            }
            if (entry != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.log.info((Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (jfile != null) {
                try {
                    jfile.close();
                }
                catch (IOException e) {
                    this.log.info((Object)("Exception when trying to close the war file: " + e.getMessage()));
                }
            }
        }
    }

    @Nullable
    private String getPartitionName() {
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(DISTRIBUTED_REPLICANT_MANAGER_MBEAN_NAME_TEMPLATE);
        try {
            List mBeans = this.loadConnection().queryBeans(queryUtility.getTranslatedQuery());
            if (mBeans.size() == 1 && queryUtility.setMatchedKeyValues(((EmsBean)mBeans.get(0)).getBeanName().getKeyProperties())) {
                return (String)queryUtility.getVariableValues().get("partitionName");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Could not load partition name as connection could not be loaded");
        }
        return null;
    }

    private synchronized EmsConnection loadConnection() throws Exception {
        if (this.connection == null) {
            try {
                Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
                String jbossHomeDir = pluginConfig.getSimpleValue(JBOSS_HOME_DIR_CONFIG_PROP, null);
                ConnectionSettings connectionSettings = new ConnectionSettings();
                String connectionTypeDescriptorClass = pluginConfig.getSimple("type").getStringValue();
                connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)Class.forName(connectionTypeDescriptorClass).newInstance());
                connectionSettings.setServerUrl(pluginConfig.getSimpleValue(NAMING_URL_CONFIG_PROP, null));
                connectionSettings.setPrincipal(pluginConfig.getSimpleValue("principal", null));
                connectionSettings.setCredentials(pluginConfig.getSimpleValue("credentials", null));
                connectionSettings.setLibraryURI(jbossHomeDir);
                ConnectionFactory connectionFactory = new ConnectionFactory();
                connectionFactory.discoverServerClasses(connectionSettings);
                if (connectionSettings.getAdvancedProperties() == null) {
                    connectionSettings.setAdvancedProperties(new Properties());
                }
                connectionSettings.getAdvancedProperties().setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, "true");
                connectionSettings.getAdvancedProperties().setProperty("jnp.timeout", String.valueOf(30000));
                connectionSettings.getAdvancedProperties().setProperty("jnp.sotimeout", String.valueOf(15000));
                connectionSettings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
                connectionSettings.getControlProperties().setProperty("mc4j.ems.JarTempDir", this.resourceContext.getTemporaryDirectory().getAbsolutePath());
                connectionSettings.getAdvancedProperties().setProperty("mc4j.ems.DefaultDomainSearch", "jboss");
                this.log.info((Object)("Loading JBoss connection [" + connectionSettings.getServerUrl() + "] with install path [" + connectionSettings.getLibraryURI() + "]..."));
                ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
                this.connection = connectionProvider.connect();
                this.connection.loadSynchronous(false);
                this.consecutiveConnectionErrors = 0;
                try {
                    this.mainDeployer = new MainDeployer(this.connection);
                }
                catch (Exception e) {
                    this.log.error((Object)("Unable to access MainDeployer MBean required for creation and deletion of managed resources - this should never happen. Cause: " + e));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Successfully made connection to the AS instance for resource [" + this.resourceContext.getResourceKey() + "]"));
                }
            }
            catch (Exception e) {
                if (this.connection != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Connection created but an exception was thrown. Closing the connection.", (Throwable)e);
                    }
                    this.connection.close();
                    this.connection = null;
                }
                if (this.consecutiveConnectionErrors % 10 == 0) {
                    this.log.warn((Object)("Could not establish connection to the JBoss AS instance [" + (this.consecutiveConnectionErrors + 1) + "] times for resource [" + this.resourceContext.getResourceKey() + "]"), (Throwable)e);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Could not connect to the JBoss AS instance for resource [" + this.resourceContext.getResourceKey() + "]"), (Throwable)e);
                }
                ++this.consecutiveConnectionErrors;
                throw e;
            }
        }
        return this.connection;
    }
}

