/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.ApplicationServerComponent;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        Set jmxResources = super.discoverResources(context);
        JMXComponent parentComponent = (JMXComponent)context.getParentResourceComponent();
        ApplicationServerComponent applicationServerComponent = (ApplicationServerComponent)parentComponent;
        EmsConnection emsConnection = parentComponent.getEmsConnection();
        String deployDirectoryPath = this.generateDeployDirectory(applicationServerComponent.getConfigurationPath().getPath());
        ArrayList<String> earNames = new ArrayList<String>();
        for (DiscoveredResourceDetails jmxResource : jmxResources) {
            earNames.add(jmxResource.getResourceName());
        }
        Map<String, String> pathMap = DeploymentUtility.getEarDeploymentPath(emsConnection, earNames);
        for (DiscoveredResourceDetails jmxResource : jmxResources) {
            Configuration pluginConfiguration = jmxResource.getPluginConfiguration();
            String path = pathMap.containsKey(jmxResource.getResourceName()) ? pathMap.get(jmxResource.getResourceName()) : deployDirectoryPath + jmxResource.getResourceName();
            pluginConfiguration.put((Property)new PropertySimple("filename", (Object)path));
        }
        Set<DiscoveredResourceDetails> fileSystemResources = this.discoverFileSystem(context);
        jmxResources.addAll(fileSystemResources);
        return jmxResources;
    }

    private Set<DiscoveredResourceDetails> discoverFileSystem(ResourceDiscoveryContext<JMXComponent> context) {
        Configuration defaultConfiguration = context.getDefaultPluginConfiguration();
        JMXComponent parentComponent = (JMXComponent)context.getParentResourceComponent();
        ApplicationServerComponent applicationServerComponent = (ApplicationServerComponent)parentComponent;
        String deployDirectoryPath = this.generateDeployDirectory(applicationServerComponent.getConfigurationPath().getPath());
        File deployDirectory = new File(deployDirectoryPath);
        String extension = defaultConfiguration.getSimple("extension").getStringValue();
        ApplicationFileFilter filter = new ApplicationFileFilter(extension);
        File[] files = deployDirectory.listFiles(filter);
        ResourceType resourceType = context.getResourceType();
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>(files.length);
        for (File file : files) {
            String resourceKey;
            String objectName = resourceKey = this.determineResourceKey(defaultConfiguration, file.getName());
            String resourceName = file.getName();
            String description = defaultConfiguration.getSimple("descriptionTemplate").getStringValue();
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, "", description, null, null);
            Configuration resourcePluginConfiguration = resource.getPluginConfiguration();
            resourcePluginConfiguration.put((Property)new PropertySimple("name", (Object)resourceName));
            resourcePluginConfiguration.put((Property)new PropertySimple("objectName", (Object)objectName));
            resourcePluginConfiguration.put((Property)new PropertySimple("filename", (Object)(deployDirectoryPath + resourceName)));
            resources.add(resource);
        }
        return resources;
    }

    private String generateDeployDirectory(String profilePath) {
        return profilePath + File.separator + "deploy" + File.separator;
    }

    private String determineResourceKey(Configuration defaultConfiguration, String fileName) {
        String template = defaultConfiguration.getSimple("objectName").getStringValue();
        String resourceKey = template.replaceAll("%name%", fileName);
        return resourceKey;
    }

    private static class ApplicationFileFilter
    implements FilenameFilter {
        private String applicationExtension;

        private ApplicationFileFilter(String applicationExtension) {
            this.applicationExtension = applicationExtension;
        }

        public boolean accept(File dir, String name) {
            boolean result = name.endsWith(this.applicationExtension);
            return result;
        }
    }
}

