/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.Configuration;

public class CacheConfigurationHelper {
    private Log log = LogFactory.getLog(CacheConfigurationHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfig(File file, Configuration config, String mbeanName, boolean isUpdate) throws JDOMException, IOException {
        Document doc = null;
        Element root = null;
        Element cacheMbean = null;
        String flavour = config.getSimple("Flavour").getStringValue();
        boolean isTc = false;
        if (flavour != null && flavour.startsWith("tree")) {
            isTc = true;
        }
        if (isUpdate) {
            if (!file.exists() || !file.canWrite()) {
                throw new IllegalStateException("Can't update file, as it is not updateaable ");
            }
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(file);
            root = doc.getRootElement();
            cacheMbean = this.findComponentElement(root, mbeanName);
            if (cacheMbean == null) {
                throw new IllegalStateException("File does not contain an MBean with name '" + mbeanName + "'");
            }
        } else {
            doc = new Document();
            root = new Element("server");
            doc.setRootElement(root);
            cacheMbean = new Element("mbean");
            cacheMbean.setAttribute("name", mbeanName);
            root.addContent((Content)cacheMbean);
        }
        if (isTc) {
            cacheMbean.setAttribute("code", "org.jboss.cache.TreeCache");
        } else {
            cacheMbean.setAttribute("code", "org.jboss.cache.PojoCache");
        }
        Element depends = new Element("depends");
        depends.setText("jboss:service=TransactionManager");
        cacheMbean.addContent((Content)depends);
        for (String propName : config.getSimpleProperties().keySet()) {
            if (propName.equals("Flavour")) continue;
            String propVal = config.getSimple(propName).getStringValue();
            Element attribute = null;
            if (isUpdate) {
                attribute = this.findAttributeNodeWithName(cacheMbean, propName);
            }
            if (attribute == null) {
                attribute = new Element("attribute");
                attribute.setAttribute("name", propName);
                cacheMbean.addContent((Content)attribute);
            }
            attribute.setText(propVal);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(doc, (OutputStream)fos);
            fos.flush();
        }
        catch (IOException ioe) {
            this.log.error((Object)("Can't write the config : " + ioe));
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private Element findAttributeNodeWithName(Element base, String propName) {
        if (propName == null) {
            return null;
        }
        for (Object attrObj : base.getChildren("attribute")) {
            Element attr;
            String nameAttrib;
            if (!(attrObj instanceof Element) || !propName.equals(nameAttrib = (attr = (Element)attrObj).getAttributeValue("name"))) continue;
            return attr;
        }
        return null;
    }

    private Element findComponentElement(Element base, String mbeanName) {
        for (Object mbeanObj : base.getChildren("mbean")) {
            if (!(mbeanObj instanceof Element)) continue;
            Element mbean = (Element)mbeanObj;
            String nameAttrib = mbean.getAttributeValue("name");
            try {
                ObjectName on = new ObjectName(nameAttrib);
                nameAttrib = on.getCanonicalName();
            }
            catch (MalformedObjectNameException e) {
                this.log.warn((Object)("Can't canonicalize " + nameAttrib));
            }
            if (!nameAttrib.equals(mbeanName)) continue;
            return mbean;
        }
        return null;
    }
}

