/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatConnectorComponent
extends MBeanResourceComponent<TomcatServerComponent> {
    public static final String PROPERTY_ADDRESS = "address";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_PROTOCOL = "protocol";
    public static final String PROPERTY_SCHEME = "scheme";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        TomcatServerComponent parentComponent = (TomcatServerComponent)this.getResourceContext().getParentResourceComponent();
        parentComponent.getEmsConnection();
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            name = this.getAttributeName(name);
            String beanName = name.substring(0, name.lastIndexOf(58));
            String attributeName = name.substring(name.lastIndexOf(58) + 1);
            try {
                EmsBean eBean = this.loadBean(beanName);
                if (eBean == null) {
                    this.log.warn((Object)("Bean " + beanName + " not found, skipping ..."));
                    continue;
                }
                EmsAttribute attribute = eBean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                Number value = (Number)valueObject;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    protected String getAttributeName(String property) {
        String theProperty = property;
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String address = pluginConfiguration.getSimple(PROPERTY_ADDRESS).getStringValue();
        String port = pluginConfiguration.getSimple(PROPERTY_PORT).getStringValue();
        String scheme = pluginConfiguration.getSimple(PROPERTY_SCHEME).getStringValue();
        theProperty = theProperty.replace("%address%", address);
        theProperty = theProperty.replace("%port%", port);
        theProperty = theProperty.replace("%scheme%", scheme);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finding metrics for: " + theProperty));
        }
        return theProperty;
    }
}

