/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatConnectorDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatServerComponent> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatServerComponent> context) {
        ObjectNameQueryUtility queryUtility;
        Set resourceDetails = super.discoverResources(context);
        EmsConnection connection = ((TomcatServerComponent)context.getParentResourceComponent()).getEmsConnection();
        List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility("Catalina:type=GlobalRequestProcessor,name=%name%")).getTranslatedQuery());
        if (beans.size() != resourceDetails.size()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"jboss.web:type=GlobalRequestProcessor,name=* MBeans are not fully deployed yet - aborting...");
            }
            return Collections.emptySet();
        }
        HashMap<String, ConfigInfo> configMap = new HashMap<String, ConfigInfo>(beans.size());
        for (EmsBean bean : beans) {
            ConfigInfo configInfo = new ConfigInfo(bean);
            if (null != configInfo.getPort()) {
                configMap.put(configInfo.port, configInfo);
                continue;
            }
            this.log.warn((Object)("Unknown ObjectName for GlobalRequestProcessor: " + configInfo.getName()));
        }
        for (DiscoveredResourceDetails resource : resourceDetails) {
            EmsAttribute protocol;
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String port = pluginConfiguration.getSimple("port").getStringValue();
            ConfigInfo configInfo = (ConfigInfo)configMap.get(port);
            pluginConfiguration.put((Property)new PropertySimple("scheme", (Object)configInfo.getScheme()));
            pluginConfiguration.put((Property)new PropertySimple("address", (Object)configInfo.getAddress()));
            resource.setResourceName(resource.getResourceName().replace("{scheme}", configInfo.getScheme()));
            queryUtility = new ObjectNameQueryUtility("Catalina:type=Connector,port=" + port);
            beans = connection.queryBeans(queryUtility.getTranslatedQuery());
            if (!beans.isEmpty() && null != (protocol = ((EmsBean)beans.get(0)).getAttribute("protocol"))) {
                pluginConfiguration.put((Property)new PropertySimple("protocol", (Object)((String)protocol.getValue())));
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Found a connector: " + configInfo.getScheme() + "-" + configInfo.getAddress() + "-" + configInfo.getPort()));
        }
        return resourceDetails;
    }

    private static class ConfigInfo {
        private static final String LOCAL_IP = "0.0.0.0";
        private String name;
        private String address;
        private String scheme;
        private String port;

        public ConfigInfo(EmsBean bean) {
            EmsBeanName eName = bean.getBeanName();
            this.name = eName.getKeyProperty("name");
            String[] tokens = this.name.split("-");
            if (tokens.length == 2) {
                this.scheme = tokens[0];
                this.port = tokens[1];
                this.address = LOCAL_IP;
            } else if (tokens.length == 3) {
                this.scheme = tokens[0];
                this.address = tokens[1];
                this.port = tokens[2];
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPort() {
            return this.port;
        }
    }
}

