/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerOperationsDelegate;
import org.jboss.on.plugins.tomcat.helper.TomcatConfig;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.platform.PlatformComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDiscoveryComponent
implements ResourceDiscoveryComponent<PlatformComponent> {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String UNKNOWN_VERSION = "Unknown Version";
    public static final String PROPERTY_CATALINA_BASE = "-Dcatalina.base=";
    public static final String PROPERTY_CATALINA_HOME = "-Dcatalina.home=";
    private static final String PRODUCT_NAME_EWS = "JBoss EWS";
    private static final String PRODUCT_NAME_APACHE = "Apache Tomcat";
    private static final String PRODUCT_DESCRIPTION_EWS = "JBoss Enterprise Web Application Server";
    private static final String PRODUCT_DESCRIPTION_APACHE = "Apache Tomcat Web Application Server";
    private static final Pattern TOMCAT_6_VERSION_PATTERN = Pattern.compile(".*Server number:.*");
    private static final Pattern TOMCAT_5_VERSION_PATTERN = Pattern.compile(".*Version:.*");
    private static final Pattern EWS_PATTERN = Pattern.compile(".*ews.*tomcat[56]");
    private static final String EWS_TOMCAT_6 = "tomcat6";
    private static final String EWS_TOMCAT_5 = "tomcat5";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        this.log.debug((Object)"Discovering Tomcat servers...");
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Discovered potential Tomcat process: " + autoDiscoveryResult));
            }
            try {
                DiscoveredResourceDetails resource = this.parseTomcatProcess(context, autoDiscoveryResult);
                if (resource == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Verified Tomcat process: " + autoDiscoveryResult));
                }
                resources.add(resource);
            }
            catch (Exception e) {
                this.log.error((Object)("Error creating discovered resource for process: " + autoDiscoveryResult), (Throwable)e);
            }
        }
        return resources;
    }

    private DiscoveredResourceDetails parseTomcatProcess(ResourceDiscoveryContext context, ProcessScanResult autoDiscoveryResult) {
        ProcessInfo processInfo = autoDiscoveryResult.getProcessInfo();
        SystemInfo systemInfo = context.getSystemInformation();
        Object[] commandLine = processInfo.getCommandLine();
        if (!this.isStandalone((String[])commandLine)) {
            this.log.info((Object)("Ignoring embedded Tomcat instance with following command line, ignoring: " + Arrays.toString(commandLine)));
            return null;
        }
        String installationPath = this.determineInstallationPath(processInfo);
        TomcatConfig tomcatConfig = this.parseTomcatConfig(installationPath);
        String resourceVersion = this.determineVersion(installationPath, systemInfo);
        String hostname = systemInfo.getHostname();
        boolean isEWS = this.isEWS(installationPath);
        String productName = isEWS ? PRODUCT_NAME_EWS : PRODUCT_NAME_APACHE;
        String productDescription = isEWS ? PRODUCT_DESCRIPTION_EWS : PRODUCT_DESCRIPTION_APACHE;
        String resourceName = (hostname == null ? "" : hostname + " ") + productName + " (" + (tomcatConfig.getAddress() == null ? "" : tomcatConfig.getAddress() + ":") + tomcatConfig.getPort() + ")";
        String resourceKey = installationPath;
        Configuration pluginConfiguration = this.populatePluginConfiguration(installationPath, (String[])commandLine);
        DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, resourceVersion, productDescription, pluginConfiguration, processInfo);
        return resource;
    }

    private boolean isStandalone(String[] commandLine) {
        for (String item : commandLine) {
            if (!item.contains("catalina.home")) continue;
            return true;
        }
        return false;
    }

    private boolean isEWS(String installationPath) {
        boolean isEws = EWS_PATTERN.matcher(installationPath).matches();
        if (!isEws) {
            isEws = this.isEWSTomcat5(installationPath) || this.isEWSTomcat6(installationPath);
        }
        return isEws;
    }

    private boolean isEWSTomcat5(String installationPath) {
        return null != installationPath && installationPath.endsWith(EWS_TOMCAT_5);
    }

    private boolean isEWSTomcat6(String installationPath) {
        return null != installationPath && installationPath.endsWith(EWS_TOMCAT_6);
    }

    private String determineInstallationPath(String[] cmdLine) {
        String result = null;
        for (int i = 0; i < cmdLine.length; ++i) {
            String line = cmdLine[i];
            if (line.startsWith(PROPERTY_CATALINA_HOME)) {
                result = line.substring(PROPERTY_CATALINA_HOME.length());
                break;
            }
            if (!line.startsWith(PROPERTY_CATALINA_BASE)) continue;
            result = line.substring(PROPERTY_CATALINA_BASE.length());
            break;
        }
        if (null != result) {
            try {
                result = new File(result).getCanonicalPath();
            }
            catch (IOException e) {
                this.log.warn((Object)("Unexpected standalone Tomcat installation path: " + result));
            }
        }
        return result;
    }

    private String determineInstallationPath(ProcessInfo processInfo) {
        String cwdPath = processInfo.getCurrentWorkingDirectory();
        File cwd = new File(cwdPath);
        return cwd.getParent();
    }

    private TomcatConfig parseTomcatConfig(String installationPath) {
        String configFileName = installationPath + File.separator + "conf" + File.separator + "server.xml";
        File configFile = new File(configFileName);
        TomcatConfig config = TomcatConfig.getConfig(configFile);
        return config;
    }

    private String determineVersion(String installationPath, SystemInfo systemInfo) {
        String version = UNKNOWN_VERSION;
        boolean isNix = File.separatorChar == '/';
        String versionScriptFileName = null;
        versionScriptFileName = this.isEWS(installationPath) ? installationPath + File.separator + "bin" + File.separator + (this.isEWSTomcat5(installationPath) ? EWS_TOMCAT_5 : EWS_TOMCAT_6) + " version" : installationPath + File.separator + "bin" + File.separator + "version." + (isNix ? "sh" : "bat");
        ProcessExecution processExecution = new ProcessExecution(versionScriptFileName);
        TomcatServerOperationsDelegate.setProcessExecutionEnvironment(processExecution, installationPath);
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(5000L);
        processExecution.setKillOnTimeout(true);
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        String versionOutput = results.getCapturedOutput();
        Matcher matcher = TOMCAT_6_VERSION_PATTERN.matcher(versionOutput);
        if (matcher.find()) {
            String serverNumberString = matcher.group();
            String[] serverNumberParts = serverNumberString.split(":");
            version = serverNumberParts[1].trim();
        } else {
            matcher = TOMCAT_5_VERSION_PATTERN.matcher(versionOutput);
            if (matcher.find()) {
                String serverNumberString = matcher.group();
                String[] serverNumberParts = serverNumberString.split("/");
                version = serverNumberParts[1].trim();
            }
        }
        if (UNKNOWN_VERSION.equals(version)) {
            this.log.warn((Object)("Failed to determine Tomcat Server Version Given:\nVersionInfo:" + versionOutput + "\ninstallationPath: " + installationPath + "\nScript:" + versionScriptFileName + "\ntimeout=5000L"));
        }
        return version;
    }

    private Configuration populatePluginConfiguration(String installationPath, String[] commandLine) {
        Configuration configuration = new Configuration();
        configuration.put((Property)new PropertySimple("installationPath", (Object)installationPath));
        String binPath = installationPath + File.separator + "bin" + File.separator;
        if (this.isEWS(installationPath)) {
            String script = this.isEWSTomcat5(installationPath) ? EWS_TOMCAT_5 : EWS_TOMCAT_6;
            configuration.put((Property)new PropertySimple("startScript", (Object)(binPath + script + " start")));
            configuration.put((Property)new PropertySimple("shutdownScript", (Object)(binPath + script + " stop")));
        } else {
            String scriptExtension = File.separatorChar == '/' ? ".sh" : ".bat";
            configuration.put((Property)new PropertySimple("startScript", (Object)(binPath + "startup" + scriptExtension)));
            configuration.put((Property)new PropertySimple("shutdownScript", (Object)(binPath + "shutdown" + scriptExtension)));
        }
        this.populateJMXConfiguration(configuration, commandLine);
        return configuration;
    }

    private void populateJMXConfiguration(Configuration configuration, String[] commandLine) {
        String portProp = "com.sun.management.jmxremote.port";
        String port = null;
        for (String argument : commandLine) {
            String cmdLineArg = "-D" + portProp + "=";
            if (!argument.startsWith(cmdLineArg)) continue;
            port = argument.substring(cmdLineArg.length());
            break;
        }
        configuration.put((Property)new PropertySimple("type", (Object)"org.mc4j.ems.connection.support.metadata.Tomcat55ConnectionTypeDescriptor"));
        if (null != port) {
            configuration.put((Property)new PropertySimple("connectorAddress", (Object)("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi")));
        }
    }
}

